#ifndef __CCmd_h__
#define __CCmd_h__

#include <string>
#include <vector>

using namespace std;

class CCmd{
public:

	enum flags_e{
		FLAG_SYSTEM =		1 << 0,
		FLAG_USER_DEFINED =	1 << 1,
//		FLAG_READ_ONLY =	1 << 2,

		FLAG_ALL =			0xFFFFFFFF,
		FLAG_NONE =			0x00000000
	};

	CCmd(const string& name);
	virtual ~CCmd() = 0;

	virtual void exec(const vector<string>& arguments) = 0;

	const string& getName() const;
	const string& getInfoString() const;
	const string& getUsageString() const;
	string getFlagsString() const;

protected:
	string name;
	string infoString;
	string usageString;

	unsigned long flags;
};


#endif	// __CCmd_h__
