#ifndef __CVar_h__
#define __CVar_h__

#include <string>

using namespace std;

class CVar{
public:

	enum types_e{
		TYPE_BOOL,
		TYPE_INT,
		TYPE_REAL,
		TYPE_STRING,
		TYPE_REAL_VECTOR,
	
		NUM_TYPES
	};

	enum flags_e{
		FLAG_SYSTEM =		1 << 0,
		FLAG_USER_DEFINED =	1 << 1,
		FLAG_READ_ONLY =	1 << 2,

		FLAG_ALL =			0xFFFFFFFF,
		FLAG_NONE =			0x00000000
	};

	CVar(const string& name);
	virtual ~CVar() = 0;

	virtual string getValueString() const = 0;
	virtual void setValueString(const string& valueString) = 0;
	virtual bool isValueStringValid(const string& valueString) const = 0;
	virtual string getValueRangeString() const = 0;

	virtual void toggle() = 0;
	virtual void updateReferencedVariable() = 0;

	virtual string getReferencedVariableValueString() const = 0;

	string getTypeString() const;
	string getFlagsString() const;
	const string& getName() const;
	const string& getInfoString() const;
	void setChangeString(const string& newChangeString);
	const string& getChangeString() const;

	void setFlags(unsigned int newFlags);
	unsigned int getFlags() const;

protected:
	
	types_e type;

	string name;
	string infoString;
	string changeString;
	
	unsigned int flags;
	bool instantUpdate;

};

class CVarBool: public CVar{
public:
	CVarBool(const string& name, bool value);
	CVarBool(const string& name, bool* referencedVariable, bool instantUpdate);
	~CVarBool();

	string getValueString() const;
	void setValueString(const string& valueString);
	bool isValueStringValid(const string& valueString) const;
	string getValueRangeString() const;

	void toggle();
	void updateReferencedVariable();

	string getReferencedVariableValueString() const;

	// bool specific stuff
	void setValueRange(bool minValue, bool maxValue);
	void setValue(bool newValue);
	bool getValue() const;

protected:
	bool* referencedVariable;
	bool value;
	bool maxValue;
	bool minValue;
};


class CVarInt: public CVar{
public:
	CVarInt(const string& name, int value);
	CVarInt(const string& name, int* referencedVariable, bool instantUpdate);
	~CVarInt();

	string getValueString() const;
	void setValueString(const string& valueString);
	bool isValueStringValid(const string& valueString) const;
	string getValueRangeString() const;

	void toggle();
	void updateReferencedVariable();

	string getReferencedVariableValueString() const;

	// int specific stuff
	void setValueRange(int minValue, int maxValue);
	void setValue(int newValue);
	int getValue() const;

protected:
	int* referencedVariable;
	int value;
	int maxValue;
	int minValue;
};


class CVarReal: public CVar{
public:
	CVarReal(const string& name, float value);
	CVarReal(const string& name, float* referencedVariable, bool instantUpdate);
	~CVarReal();

	string getValueString() const;
	void setValueString(const string& valueString);
	bool isValueStringValid(const string& valueString) const;
	string getValueRangeString() const;

	void toggle();
	void updateReferencedVariable();

	string getReferencedVariableValueString() const;

	// float specific stuff
	void setValueRange(float minValue, float maxValue);
	void setValue(float newValue);
	float getValue() const;

protected:
	float* referencedVariable;
	float value;
	float maxValue;
	float minValue;
};



class CVarString: public CVar{
public:
	CVarString(const string& name, const string& value);
	CVarString(const string& name, string* referencedVariable, bool instantUpdate);
	~CVarString();

	string getValueString() const;
	void setValueString(const string& valueString);
	bool isValueStringValid(const string& valueString) const;
	string getValueRangeString() const;

	void toggle();
	void updateReferencedVariable();

	string getReferencedVariableValueString() const;

	// string specific stuff
	void setLengthRange(int minLength, int maxLength);
	void setValue(const string& newValue);
	const string& getValue() const;

protected:
	string* referencedVariable;
	string value;
	int maxLength;
	int minLength;
};




#endif // __CVar_h__
