#ifndef __Console_h__
#define __Console_h__

#include "SubSystem.h"

#include "ConsoleCCmds.h"
#include "File.h"
#include "FColor.h"

#include <string>
using namespace std;

class ConsoleBackEnd;
class ConsoleFrontEnd;
class CVar;

class Console: public SubSystem{
public:
	Console(System* system);
	~Console();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	void queuePrintString( const string& printString, const FColor& color = FColor::WHITE );
	void queueInputString( const string& inputString );
	void processQueues();

	void parse( const string& parseString );

	void registerCVar(CVar *cVar);
	void unregisterCVar(CVar *cVar);
	CVar* getCVar(const string& name) const;
	void writeCVarSettingsToFile( File& file ) const;

	void registerCCmd(CCmd *cCmd);
	void unregisterCCmd(CCmd *cCmd);
	CCmd* getCCmd(const string& name) const ;

protected:
	ConsoleBackEnd* backEnd;
	ConsoleFrontEnd* frontEnd;

	struct cVars_s{

	};
	cVars_s cVars;
	struct cCmds_s{
		CCmdRegisterCVar* registercvar;
		CCmdUnregisterCVar* unregistercvar;
		CCmdSet* set;
		CCmdVal* val;
		CCmdHelp* help;
		CCmdInfo* info;
		CCmdToggle* toggle;
		CCmdExec* exec;
		CCmdCVarList* cvarlist;
		CCmdCCmdList* ccmdlist;
		CCmdEcho* echo;
	};
	cCmds_s cCmds;

};


#endif	// __Console_h__
