#include "ConsoleBackEnd.h"

#include "StringTokenizer.h"
#include "System.h"

#include <iostream>

ConsoleBackEnd::ConsoleBackEnd(Console* console){
	cVarsByName.clear();
	cCmdsByName.clear();

	this->console = console;
}

ConsoleBackEnd::~ConsoleBackEnd(){
	cVarsByName.clear();
	cCmdsByName.clear();
//	cAliasesByName.clear();
//	outputLines.clear();
}

void ConsoleBackEnd::parse( const string& parseString ){

//	System::log( "console: parsing [%s]", parseString.c_str() );

	StringTokenizer st( " \t\r\n=", "\"", false );

	const vector<string>& tokens = st.tokenize( parseString );

//	for(unsigned int i=0;i<tokens.size(); i++){
//		System::log("token %d: [%s]", i, tokens[i].c_str() );;
//	}


	CCmd* cCmd = NULL;
	CVar* cVar = NULL;
//	CAlias* alias = NULL;

	if( tokens.size() == 0 ){
		return;
	}

	cCmd = this->getCCmd( tokens[0] );
	if(cCmd != NULL){
		vector<string>::const_iterator const_iter = tokens.begin();
		const_iter++;
		vector<string> arguments( const_iter, tokens.end() );

		cCmd->exec( arguments );
	}else{		// cCmd is NULL -> search for a cVar
		cVar = getCVar( tokens[0] );
		if( cVar != NULL){	// found cVar
			if( tokens.size() == 1 ){
//				outputStream << "value of '" << cVar->getName() << "': '" << cVar->getValueString() << "' (internal value: '" << cVar->getReferencedVariableValueString() << "')" << endl;
				System::log("console: value of '%s': '%s' (internal value: '%s')"
					, cVar->getName().c_str(), cVar->getValueString().c_str(), cVar->getReferencedVariableValueString().c_str() );
			}else if( tokens.size() == 2 ){
				if( (cVar->getFlags() & CVar::FLAG_READ_ONLY) == CVar::FLAG_READ_ONLY ){
					// read only
					System::log("console: '%s' is read-only.", cVar->getName().c_str() );
				}else{
					// set var
					if( cVar->isValueStringValid(tokens[1]) ){
						cVar->setValueString( tokens[1] );
						System::log("console: '%s' set to '%s' %s", cVar->getName().c_str(), cVar->getValueString().c_str(), cVar->getChangeString().c_str() );
						return;
					}else{
						System::log("console: '%s' is not a valid value for '%s'", tokens[1].c_str(), cVar->getName().c_str() );
						return;
					}
					System::log("console: '%s' set to '%s' %s", cVar->getName().c_str(), cVar->getValueString().c_str(), cVar->getChangeString().c_str() );
				}
			}else{
				// syntax error: too many tokens
				System::log("console: to many tokens");
			}
		}else{	// no cvar found
			// unknown cmd or var: 'blabla'
			System::log("console: unknown ccmd or cvar: '%s'", tokens[0].c_str() );
		}
	}


}


void ConsoleBackEnd::registerCVar(CVar* cVar){
	cVarsByName.insert( cVarsByName_t::value_type(cVar->getName(), cVar) );
}

void ConsoleBackEnd::unregisterCVar(CVar* cVar){
	cVarsByName.erase( cVar->getName() );
}

CVar* ConsoleBackEnd::getCVar(const string& name) const {
	cVarsByName_t::const_iterator c_iter = cVarsByName.find( name );

	if( c_iter == cVarsByName.end() ){
		return NULL;
	}else{
		return c_iter->second;
	}
}

void ConsoleBackEnd::collectRegisteredCVars( vector<CVar*>& ret ) const {
	for( cVarsByName_t::const_iterator c_iter = cVarsByName.begin(); c_iter != cVarsByName.end(); c_iter++ ){
		ret.push_back( c_iter->second );
	}
}


void ConsoleBackEnd::registerCCmd(CCmd* cCmd){
	cCmdsByName.insert( cCmdsByName_t::value_type(cCmd->getName(), cCmd) );
}

void ConsoleBackEnd::unregisterCCmd(CCmd* cCmd){
	cCmdsByName.erase( cCmd->getName() );
}

CCmd* ConsoleBackEnd::getCCmd(const string& name) const {
	cCmdsByName_t::const_iterator c_iter = cCmdsByName.find( name );

	if( c_iter == cCmdsByName.end() ){
		return NULL;
	}else{
		return c_iter->second;
	}
}


/*
void ConsoleBackEnd::registerCAlias(CAlias* cAlias){
	cAliasesByName.insert( cAliasesByName_t::value_type(cAlias->getName(), cAlias) );
}

void ConsoleBackEnd::unregisterCAlias(CAlias* cAlias){
	cAliasesByName.erase( cAlias->getName() );
}

CAlias* ConsoleBackEnd::getCAlias(const string& name) const {
	cAliasesByName_t::const_iterator c_iter = cAliasesByName.find( name );

	if( c_iter == cAliasesByName.end() ){
		return NULL;
	}else{
		return c_iter->second;
	}
}
*/







