#ifndef __ConsoleBackEnd_h__
#define __ConsoleBackEnd_h__

#include <map>
#include <vector>

#include "CVar.h"
#include "CCmd.h"
#include "CAlias.h"

class Console;

using namespace std;

class ConsoleBackEnd{
public:

	ConsoleBackEnd(Console* console);
	~ConsoleBackEnd();

	void parse(const string& parseString);

	void registerCVar(CVar* cVar);
	void unregisterCVar(CVar* cVar);
	CVar* getCVar(const string& name) const;
	void collectRegisteredCVars( vector<CVar*>& ret ) const;

	void registerCCmd(CCmd* cCmd);
	void unregisterCCmd(CCmd* cCmd);
	CCmd* getCCmd(const string& name) const ;

//	void registerAlias(CAlias *alias);
//	void unregisterAlias(CAlias *alias);
//	CAlias* getAlias(const string& name) const;


protected:
	typedef map<string, CVar*> cVarsByName_t;
	typedef map<string, CCmd*> cCmdsByName_t;
//	typedef map<string, CAlias*> cAliasesByName_t;

	cVarsByName_t cVarsByName;
	cCmdsByName_t cCmdsByName;
//	cAliasesByName_t cAliasesByName;

	Console* console;
};


#endif // __ConsoleBackEnd_h__
