#include "ConsoleFrontEnd.h"

#include "System.h"
#include "Console.h"
#include "Gui.h"
#include "ConsoleMenu.h"

ConsoleFrontEnd::ConsoleFrontEnd(Console* console){
	printStrings.clear();
	inputStrings.clear();
//	parseStrings.clear();

	this->console = console;
}

ConsoleFrontEnd::~ConsoleFrontEnd(){
}

void ConsoleFrontEnd::queuePrintString(const string& printString){
	printString_t ps( printString, FColor() );
	printStrings.push_back( ps );
}
void ConsoleFrontEnd::queuePrintString(const string& printString, const FColor& color){
	printString_t ps( printString, color );
	printStrings.push_back( ps );
}
void ConsoleFrontEnd::queueInputString(const string& inputString){
	inputStrings.push_back(inputString);
}

void ConsoleFrontEnd::processPrintStrings(){
	if( !console->getSystem()->getGui()->isInitialized() ){
		printStrings.clear();
		return;
	}

	ConsoleMenu* consoleMenu = console->getSystem()->getGui()->getConsoleMenu();
	vector<printString_t>::iterator iter;
	for( iter = printStrings.begin(); iter != printStrings.end(); iter++ ){
		consoleMenu->printLine( iter->first, iter->second );
	}

	printStrings.clear();
}
void ConsoleFrontEnd::processInputStrings(){

	vector<string>::iterator iter;
	for( iter = inputStrings.begin(); iter != inputStrings.end(); iter++ ){
		// print string
		System::log("> %s", (*iter).c_str() );

		// parse string
		console->parse( *iter );

	}

	inputStrings.clear();
}

