#ifndef __ConsoleFrontEnd_h__
#define __ConsoleFrontEnd_h__

#include "FColor.h"

#include <vector>
#include <string>
using namespace std;

class Console;


class ConsoleFrontEnd{
public:
	ConsoleFrontEnd(Console* console);
	~ConsoleFrontEnd();

	void queueInputString(const string& inputString);
	void queuePrintString(const string& printString);
	void queuePrintString(const string& printString, const FColor& color);

	void processInputStrings();
	void processPrintStrings();

protected:
	vector<string> inputStrings;
	typedef pair<string, FColor> printString_t;
	vector<printString_t> printStrings;

	Console* console;
};


#endif // __ConsoleFrontEnd_h__
