#ifndef __ConsoleMenu_h__
#define __ConsoleMenu_h__

#include "Menu.h"
#include "FColor.h"

#include <elements/CEGUIEditbox.h>
#include <elements/CEGUIListbox.h>

class ConsoleMenu: public Menu{
public:
	ConsoleMenu(Gui* gui);
	~ConsoleMenu();

	void show();
	void hide();

	void registerEventHandlers();

	void printLine(const string& line);
	void printLine(const string& line, const FColor& color);

protected:
	CEGUI::Listbox* listbox;
	CEGUI::Editbox* editbox;

	bool handleEditboxTextAccepted(const CEGUI::EventArgs& e);
	bool handleListboxSelectionChanged(const CEGUI::EventArgs& e);
	bool handleCloseClicked(const CEGUI::EventArgs& e);
};

#endif // __ConsoleMenu_h__
