#ifndef __DotSceneLoader_h__
#define __DotSceneLoader_h__


#include <Ogre.h>

#include <tinyxml.h>

#include <string>
using namespace std;

class DotSceneLoader{
public:
	DotSceneLoader(const string& dotSceneFilePath, Ogre::SceneManager* sceneManager
		, Ogre::SceneNode* rootNode = NULL, bool staticMeshes = false, bool castShadows = true);
	~DotSceneLoader();

	void load();

protected:
	string dotSceneFilePath;
	Ogre::RenderWindow* renderWindow;
	Ogre::SceneManager* sceneManager;
	Ogre::SceneNode* rootNode;
	bool staticMeshes;
	bool castShadows;

	int nodeCounter;
	int entityCounter;
	int lightCounter;
	int billboardSetCounter;
	int particleSystemCounter;


	void parseEnvironment(TiXmlElement* environmentElement);
	void parseSkyBox(TiXmlElement* skyBoxElement);
	void parseSkyDome(TiXmlElement* skyDomeElement);
	void parseSkyPlane(TiXmlElement* skyPlaneElement);
	void parseFog(TiXmlElement* fogElement);

	void parseNodes(TiXmlElement* nodesElement);
	void parseNode(Ogre::SceneNode* parentNode, TiXmlElement* nodeElement);
	void parseEntity(Ogre::SceneNode* parentNode, TiXmlElement* entityElement);
	void parseLight(Ogre::SceneNode* parentNode, TiXmlElement* lightElement);
	void parseCamera(Ogre::SceneNode* parentNode, TiXmlElement* cameraElement);
	void parseBillboardSet(Ogre::SceneNode* parentNode, TiXmlElement* billboardSetElement);
	void parseBillboard(Ogre::BillboardSet* parentBillboardSet, TiXmlElement* billboardElement);
	void parseParticleSystem(Ogre::SceneNode* parentNode, TiXmlElement* particleSystemElement);
};


#endif // __DotSceneLoader_h__
