#ifndef __DynamicGeometry_h__
#define __DynamicGeometry_h__

#include "Geometry.h"

class DynamicGeometry: public Geometry {
public:

	DynamicGeometry();
	~DynamicGeometry();

	void reset();
	Geometry* clone() const;


	virtual void attach( Game* game );
	virtual void detach();
	virtual void update( float deltaT );

	// Physics interface
	virtual void prepareForSimulationStep();
	virtual void updateAfterSimulationStep();
	virtual bool collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact);
	virtual bool collidedWithTerrain(const FVector3& contactPoint, dContact& contact);
	virtual void addLinearImpulse( const FVector3& impulse, const FVector3& position );
	virtual void addAngularImpulse( const FVector3& impulse );

	virtual void damage( float amount );
	virtual void explode();

	bool shouldBeDetached() const;

protected:

	Ogre::StaticGeometry* staticGeometry;
	Ogre::Entity* entity;
	Ogre::SceneNode* sceneNode;

	dBodyID body;

	float health;
	bool exploded;

};

#endif // __DynamicGeometry_h__
