#ifndef __EffectFactory_h__
#define __EffectFactory_h__

#include "Effect.h"

class Game;

#include <map>
using namespace std;

class EffectFactory{
public:
	EffectFactory(Game* game);
	~EffectFactory();

	void addEffect(const string& EffectFilePath);
	void removeEffect(const string& name);

	Effect* createEffect(const string& name) const;
	void destroyEffect(Effect* effect) const;

//	vector<string> getEffectNames() const;
protected:
	Game* game;

	typedef map<string, Effect*> effectsByName_t;
	effectsByName_t effectsByName;

};

#endif // __EffectFactory_h__
