#include "EquipmentMenu.h"

#include "System.h"
#include "Gui.h"
#include "Game.h"
#include "Network.h"
#include "GameInfoMenu.h"
#include "Server.h"
#include "VehicleFactory.h"
#include "WeaponFactory.h"

EquipmentMenu::EquipmentMenu(Gui* gui): Menu(gui, "equipment_menu.layout.xml") {
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	this->teamCombobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/TeamCombobox")
		);

	this->vehicleCombobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/VehicleCombobox")
		);
	this->weapon1Combobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/Weapon1Combobox")
		);
	this->weapon2Combobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/Weapon2Combobox")
		);
	this->weapon3Combobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/Weapon3Combobox")
		);
	this->weapon4Combobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/Weapon4Combobox")
		);

	this->descriptionMultiLineEditbox = static_cast<CEGUI::MultiLineEditbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/DescriptionMultiLineEditbox")
		);

}

EquipmentMenu::~EquipmentMenu(){
}

void EquipmentMenu::show(){
	Game* game = this->gui->getSystem()->getGame();
	if( !game->isRunning() ){
		return;
	}

	Menu::show();

	// init gui elements
	int i;
	CEGUI::ListboxTextItem *listboxItem = NULL; // universal pointer for listboxItems

	Network* network = this->gui->getSystem()->getNetwork();
	
	// teams
	if( game->isRunningTeamMode() ){
		this->teamCombobox->resetList();
		for( i=0; i<Game::NUM_TEAMS; i++ ){
			if( i != Game::TEAM_PLAYERS ){
				listboxItem = new SingleColumnListboxItem( Game::getTeamName(i), i );
			}else{
				listboxItem = new SingleColumnListboxItem( "auto", i );
			}
			this->teamCombobox->addItem(listboxItem);
			listboxItem->setSelected( false );
		}

		int t = network->cVars.network_client_team->getValue();
		if( t == 0 ){ // THINKABOUTME: autoselect players when in spectators?
			t = 1;
		}
		if( t < Game::NUM_TEAMS ){
			if( t != Game::TEAM_PLAYERS ){
				this->teamCombobox->setText( Game::getTeamName( t ) );
			}else{
				this->teamCombobox->setText( "auto" );
			}
			this->teamCombobox->setItemSelectState( (size_t)t, true );
		}else{
			this->teamCombobox->setText( Game::getTeamName( 0 ) );
			this->teamCombobox->setItemSelectState( (size_t)0, true );
		}
	}else{
		this->teamCombobox->resetList();
		for( i=0; i<=Game::TEAM_PLAYERS; i++ ){
			listboxItem = new SingleColumnListboxItem( Game::getTeamName(i), i );
			this->teamCombobox->addItem(listboxItem);
			listboxItem->setSelected( false );
		}

		int t = network->cVars.network_client_team->getValue();
		if( t == 0 ){ // THINKABOUTME: autoselect players when in spectators?
			t = 1;
		}
		if( t <= Game::TEAM_PLAYERS ){
			this->teamCombobox->setText( Game::getTeamName( t ) );
			this->teamCombobox->setItemSelectState( (size_t)t, true );
		}else{
			this->teamCombobox->setText( Game::getTeamName( 0 ) );
			this->teamCombobox->setItemSelectState( (size_t)0, true );
		}
	}

	// vehicles
	const vector<string>& availableVehicles = network->getServer()->properties.availableVehicles;
	this->vehicleCombobox->resetList();
	for( i=0; i<(signed int)availableVehicles.size(); i++ ){
		listboxItem = new SingleColumnListboxItem( availableVehicles[i], i );
		this->vehicleCombobox->addItem(listboxItem);
		listboxItem->setSelected( false );
	}

	int v = network->cVars.network_client_vehicle->getValue();
	if( v < (signed int)availableVehicles.size() ){
		this->vehicleCombobox->setText( availableVehicles[v] );
		this->vehicleCombobox->setItemSelectState( (size_t)v, true );
	}else{
		this->vehicleCombobox->setText( availableVehicles[0] );
		this->vehicleCombobox->setItemSelectState( (size_t)0, true );
	}
	this->handleVehicleComboboxListSelectionAccepted( CEGUI::WindowEventArgs(this->vehicleCombobox) );

	// weapons
	const vector<string>& availableWeapons = network->getServer()->properties.availableWeapons;

	// weapon 1
	this->weapon1Combobox->resetList();

	listboxItem = new SingleColumnListboxItem( "[leave empty]", 16 );
	this->weapon1Combobox->addItem(listboxItem);
	listboxItem->setSelected( false );

	for( i=0; i<(signed int)availableWeapons.size(); i++ ){
		listboxItem = new SingleColumnListboxItem( availableWeapons[i], i );
		this->weapon1Combobox->addItem(listboxItem);
		listboxItem->setSelected( false );
	}

	int w1 = network->cVars.network_client_weapon1->getValue();
	if( w1 >= 0 && w1 < (signed int)availableWeapons.size() ){
		this->weapon1Combobox->setText( availableWeapons[w1] );
		this->weapon1Combobox->setItemSelectState( (size_t)( w1+1 ), true );
	}else{
		this->weapon1Combobox->setText( "[leave empty]" );
		this->weapon1Combobox->setItemSelectState( (size_t)0, true );
	}

	// weapon 2
	this->weapon2Combobox->resetList();

	listboxItem = new SingleColumnListboxItem( "[leave empty]", 16 );
	this->weapon2Combobox->addItem(listboxItem);
	listboxItem->setSelected( false );

	for( i=0; i<(signed int)availableWeapons.size(); i++ ){
		listboxItem = new SingleColumnListboxItem( availableWeapons[i], i );
		this->weapon2Combobox->addItem(listboxItem);
		listboxItem->setSelected( false );
	}

	int w2 = network->cVars.network_client_weapon2->getValue();
	if( w2 >= 0 && w2 < (signed int)availableWeapons.size() ){
		this->weapon2Combobox->setText( availableWeapons[w2] );
		this->weapon2Combobox->setItemSelectState( (size_t)( w2+1 ), true );
	}else{
		this->weapon2Combobox->setText( "[leave empty]" );
		this->weapon2Combobox->setItemSelectState( (size_t)0, true );
	}
	
	// weapon 3
	this->weapon3Combobox->resetList();

	listboxItem = new SingleColumnListboxItem( "[leave empty]", 16 );
	this->weapon3Combobox->addItem(listboxItem);
	listboxItem->setSelected( false );

	for( i=0; i<(signed int)availableWeapons.size(); i++ ){
		listboxItem = new SingleColumnListboxItem( availableWeapons[i], i );
		this->weapon3Combobox->addItem(listboxItem);
		listboxItem->setSelected( false );
	}

	int w3 = network->cVars.network_client_weapon3->getValue();
	if( w3 >= 0 && w3 < (signed int)availableWeapons.size() ){
		this->weapon3Combobox->setText( availableWeapons[w3] );
		this->weapon3Combobox->setItemSelectState( (size_t)( w3+1 ), true );
	}else{
		this->weapon3Combobox->setText( "[leave empty]" );
		this->weapon3Combobox->setItemSelectState( (size_t)0, true );
	}

	// weapon 4
	this->weapon4Combobox->resetList();

	listboxItem = new SingleColumnListboxItem( "[leave empty]", 16 );
	this->weapon4Combobox->addItem(listboxItem);
	listboxItem->setSelected( false );

	for( i=0; i<(signed int)availableWeapons.size(); i++ ){
		listboxItem = new SingleColumnListboxItem( availableWeapons[i], i );
		this->weapon4Combobox->addItem(listboxItem);
		listboxItem->setSelected( false );
	}

	int w4 = network->cVars.network_client_weapon4->getValue();
	if( w4 >= 0 && w4 < (signed int)availableWeapons.size() ){
		this->weapon4Combobox->setText( availableWeapons[w4] );
		this->weapon4Combobox->setItemSelectState( (size_t)( w4+1 ), true );
	}else{
		this->weapon4Combobox->setText( "[leave empty]" );
		this->weapon4Combobox->setItemSelectState( (size_t)0, true );
	}
}

void EquipmentMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(
			wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow")
		);
	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleCloseClicked, this )
		);

	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/EquipmentMenuWindow/AcceptButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleAcceptButtonClicked, this )
		);

   this->vehicleCombobox->subscribeEvent(
			CEGUI::Combobox::EventListSelectionAccepted,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleVehicleComboboxListSelectionAccepted, this )
		);

   this->weapon1Combobox->subscribeEvent(
			CEGUI::Combobox::EventListSelectionAccepted,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleWeaponComboboxListSelectionAccepted, this )
		);
   this->weapon2Combobox->subscribeEvent(
			CEGUI::Combobox::EventListSelectionAccepted,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleWeaponComboboxListSelectionAccepted, this )
		);
   this->weapon3Combobox->subscribeEvent(
			CEGUI::Combobox::EventListSelectionAccepted,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleWeaponComboboxListSelectionAccepted, this )
		);
   this->weapon4Combobox->subscribeEvent(
			CEGUI::Combobox::EventListSelectionAccepted,
			CEGUI::Event::Subscriber( &EquipmentMenu::handleWeaponComboboxListSelectionAccepted, this )
		);

}

bool EquipmentMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}
bool EquipmentMenu::handleAcceptButtonClicked(const CEGUI::EventArgs& e){
	Network* network = this->gui->getSystem()->getNetwork();

	this->hide();
	if( this->gui->getGameInfoMenu()->isVisible() ){
		this->gui->getGameInfoMenu()->hide();
	}
	
	// team
	CEGUI::ListboxItem* lbi = this->teamCombobox->getSelectedItem();
	if( lbi != NULL ){
		network->cVars.network_client_team->setValue( lbi->getID() );
	}

	// vehicle
	lbi = this->vehicleCombobox->getSelectedItem();
	if( lbi != NULL ){
		network->cVars.network_client_vehicle->setValue( lbi->getID() );
	}

	// weapons
	lbi = this->weapon1Combobox->getSelectedItem();
	if( lbi != NULL ){
		int val = lbi->getID();
		val = val == 16 ? -1 : val; // 16 codes for -1 (= no weapon)
		network->cVars.network_client_weapon1->setValue( val );
	}
	lbi = this->weapon2Combobox->getSelectedItem();
	if( lbi != NULL ){
		int val = lbi->getID();
		val = val == 16 ? -1 : val;
		network->cVars.network_client_weapon2->setValue( val );
	}
	lbi = this->weapon3Combobox->getSelectedItem();
	if( lbi != NULL ){
		int val = lbi->getID();
		val = val == 16 ? -1 : val;
		network->cVars.network_client_weapon3->setValue( val );
	}
	lbi = this->weapon4Combobox->getSelectedItem();
	if( lbi != NULL ){
		int val = lbi->getID();
		val = val == 16 ? -1 : val;
		network->cVars.network_client_weapon4->setValue( val );
	}

	System::log("EquipmentMenu: Changes will take effect when you respawn (use 'game.kill' (default key: k) to kill yourself).");

	return true;
}

bool EquipmentMenu::handleVehicleComboboxListSelectionAccepted(const CEGUI::EventArgs& e){
    string vehicleName = string( this->vehicleCombobox->getText().c_str() );

	string description = this->gui->getSystem()->getGame()->getVehicleFactory()->getVehicleDescription( vehicleName );

	this->descriptionMultiLineEditbox->setText( description );

	int numWeaponSlots = this->gui->getSystem()->getGame()->getVehicleFactory()->getVehicleNumWeaponSlots( vehicleName );
	if( numWeaponSlots >= 1 ){
		this->weapon1Combobox->show();
//		this->weapon1Combobox->setEnabled(true);
	}else{
		this->weapon1Combobox->hide();
//		this->weapon1Combobox->setEnabled(false);
	}
	if( numWeaponSlots >= 2 ){
		this->weapon2Combobox->show();
//		this->weapon2Combobox->setEnabled(true);
	}else{
		this->weapon2Combobox->hide();
//		this->weapon2Combobox->setEnabled(false);
	}
	if( numWeaponSlots >= 3 ){
		this->weapon3Combobox->show();
//		this->weapon3Combobox->setEnabled(true);
	}else{
		this->weapon3Combobox->hide();
//		this->weapon3Combobox->setEnabled(false);
	}
	if( numWeaponSlots >= 4 ){
		this->weapon4Combobox->show();
//		this->weapon4Combobox->setEnabled(true);
	}else{
		this->weapon4Combobox->hide();
//		this->weapon4Combobox->setEnabled(false);
	}

    return true;
}

bool EquipmentMenu::handleWeaponComboboxListSelectionAccepted(const CEGUI::EventArgs& e){
	CEGUI::Combobox* weaponCombobox = (CEGUI::Combobox*)( ((CEGUI::WindowEventArgs&)e).window );

    string weaponName = string( weaponCombobox->getText().c_str() );

	WeaponFactory* weaponFactory = this->gui->getSystem()->getGame()->getWeaponFactory();
	string description;
	if( weaponFactory->isWeaponAvailable( weaponName ) ){
		description = weaponFactory->getWeaponDescription( weaponName );
	}else{
		description = "[select a weapon to get a description]";
	}

	this->descriptionMultiLineEditbox->setText( description );

    return true;
}
