#include "Exception.h"


Exception::Exception(const string& description, const string& source){
	this->description = description;
	this->source = source;
	this->stackTrace.clear();
}

Exception::Exception(const std::exception& e){
	this->description = string( e.what() );
	this->source = "<std::exception>";
	this->stackTrace.clear();
}

Exception::Exception(const Ogre::Exception& e){
	this->description = string( e.getFullDescription().c_str() );
	this->source = "<Ogre::Exception>";
	this->stackTrace.clear();
}

Exception::Exception(const CEGUI::Exception& e){
	this->description = string( e.getMessage().c_str() );
	this->source = "<CEGUI::Exception>";
	this->stackTrace.clear();
}

Exception::~Exception(){
//	this->stackTrace.clear();
}

const string& Exception::getDescription() const {
	return this->description;
}

string Exception::getFullInfo() const {

	string fullInfo = "Description: " + this->description + "\n"
					+ "Source: " + this->source + "\n"
					+ "StackTrace: " + "\n";

	vector<string>::const_iterator iter = stackTrace.begin();
	while( iter != stackTrace.end() ){
		fullInfo += (*iter) + "\n";
		iter++;
	}

	return fullInfo;
}

void Exception::printFullInfo( ostream& os ) const {

	os << "Description: " << this->description << endl;
	os << "Source: " << this->source << endl;
	os << "StackTrace: " << endl;

	vector<string>::const_iterator iter = stackTrace.begin();
	while( iter != stackTrace.end() ){
		os << (*iter) << endl;
		iter++;
	}
}

void Exception::pushStackTraceItem( const string& stackTraceItem ){
	stackTrace.push_back( stackTraceItem );
}

//string Exception::popStackTraceItem(){
//}
