#ifndef __FColor_h__
#define __FColor_h__

#include <OgreColourValue.h>
#include <CEGUIcolour.h>

class FColor{
public:

	union {
		struct {
			float r,g,b,a;
		};
		float components[4];
	};

	static const FColor WHITE;
	static const FColor BLACK;
	static const FColor RED;
	static const FColor GREEN;
	static const FColor BLUE;
	static const FColor YELLOW;
	static const FColor MAGENTA;
	static const FColor CYAN;

	FColor( float red = 1.0f, float green = 1.0f, float blue = 1.0f, float alpha = 1.0f );

	bool operator == ( const FColor& other ) const;
	bool operator != ( const FColor& other ) const;

	FColor operator + ( const FColor& other ) const;
	FColor operator - ( const FColor& other ) const;
	FColor operator * ( float scalar ) const;
	FColor operator * ( const FColor& other ) const;
	FColor operator / ( const FColor& other) const;
	FColor operator / ( float scalar ) const;


	friend FColor operator * ( float scalar, const FColor& color );

	// TODO: +=, -=, ...

	CEGUI::colour toCeguiColour() const;
	Ogre::ColourValue toOgreColourValue() const;
};



inline FColor::FColor( float red, float green, float blue, float alpha ) : r(red), g(green), b(blue), a(alpha) { }

inline FColor FColor::operator + ( const FColor& other ) const {
	return FColor( r+other.r, g+other.g, b+other.b, a+other.a );
}

inline FColor FColor::operator - ( const FColor& other ) const {
	return FColor( r-other.r, g-other.g, b-other.b, a-other.a );
}

inline FColor FColor::operator * ( float scalar ) const {
	return FColor( r*scalar, g*scalar, b*scalar, a*scalar );
}

inline FColor FColor::operator * ( const FColor& other ) const {
	return FColor( r*other.r, g*other.g, b*other.b, a*other.a );
}

inline FColor FColor::operator / ( const FColor& other ) const {
	return FColor( r/other.r, g/other.g, b/other.b, a/other.a );
}

inline FColor FColor::operator / ( float scalar ) const {
	return FColor( r/scalar, g/scalar, b/scalar, a/scalar );
}

inline FColor operator * ( float scalar, const FColor& color ){
	return FColor(scalar*color.r, scalar*color.g, scalar*color.b, scalar*color.a);
}



inline CEGUI::colour FColor::toCeguiColour() const {
	return CEGUI::colour( r, g, b, a );
}

inline Ogre::ColourValue FColor::toOgreColourValue() const {
	return Ogre::ColourValue( r, g, b, a );
}


#endif // __FColor_h__
