#ifndef __FQuaternion_h__
#define __FQuaternion_h__

#include <Ogre.h>
//#include <OgreNoMemoryMacros.h>
#include <ode/ode.h>
//#include <OgreMemoryMacros.h>

class FQuaternion{
public:
	static const FQuaternion IDENTITY;

	union{
		struct{
			float s, x, y, z;
		};
		float components[4];
	};

	FQuaternion();

	FQuaternion(float qs, float qx, float qy, float qz);
	FQuaternion(const float q[4]);
	FQuaternion(const Ogre::Quaternion ogreQuaternion);
//	FQuaternion(const float* const q);

	FQuaternion(double qs, double qx, double qy, double qz);
	FQuaternion(const double q[4]);
//	FQuaternion(const double* const q);
	
	~FQuaternion();

	Ogre::Quaternion toOgreQuaternion() const;
	void toOdeVector4( dVector4& dv ) const;
	void toFloatArray( float* array ) const;

	// TODO: slerp, ...

	friend std::ostream& operator << ( std::ostream& os, const FQuaternion& quaternion );
};


inline FQuaternion::FQuaternion() { }

inline FQuaternion::FQuaternion(float qs, float qx, float qy, float qz): s(qs), x(qx), y(qy), z(qz) { }
inline FQuaternion::FQuaternion(const float q[4]): s(q[0]), x(q[1]), y(q[2]), z(q[3]) { }
//inline FQuaternion::FQuaternion(const float* const q): s(q[0]), x(q[1]), y(q[2]), z(q[3]) { }

inline FQuaternion::FQuaternion(double qs, double qx, double qy, double qz): s(qs), x(qx), y(qy), z(qz) { }
inline FQuaternion::FQuaternion(const double q[4]): s(q[0]), x(q[1]), y(q[2]), z(q[3]) { }
//inline FQuaternion::FQuaternion(const double* const q): s(q[0]), x(q[1]), y(q[2]), z(q[3]) { }

inline FQuaternion::FQuaternion(const Ogre::Quaternion ogreQuaternion):
	s(ogreQuaternion.w), x(ogreQuaternion.x), y(ogreQuaternion.y), z(ogreQuaternion.z) {}


inline FQuaternion::~FQuaternion() {}

inline Ogre::Quaternion FQuaternion::toOgreQuaternion() const {
	return Ogre::Quaternion(s, x, y, z);
}
inline void FQuaternion::toOdeVector4( dVector4& dv ) const {
	dv[0] = s;
	dv[1] = x;
	dv[2] = y;
	dv[3] = z;
}
inline void FQuaternion::toFloatArray( float* array ) const {
	array[0] = s;
	array[1] = x;
	array[2] = y;
	array[3] = z;
}

inline std::ostream& operator << ( std::ostream& os, const FQuaternion& fquaternion ){
	os << "(" << fquaternion.s << ", " << fquaternion.x << ", " << fquaternion.y << ", " << fquaternion.z << ")";
	return os;
}


#endif // __FQuaternion_h__
