#ifndef __GameObject_h__
#define __GameObject_h__


#include "FQuaternion.h"
#include "FVectors.h"

class Game;

class GameObject{
public:

	enum gameObjectTypes_e{
		GAME_OBJECT_TYPE_GAME_OBJECT = 0,
		GAME_OBJECT_TYPE_CAMERA,

		GAME_OBJECT_TYPE_VEHICLE,
		GAME_OBJECT_TYPE_SHOT,
		GAME_OBJECT_TYPE_GEOMETRY,
		GAME_OBJECT_TYPE_EFFECT,

//		GAME_OBJECT_TYPE_AREA,

		NUM_GAME_OBJECT_TYPES
	};

	// position and velocities
	FVector3 position;
	FVector3 velocity;
	FVector3 angularVelocity;

	// orientation with vectors
	FVector3 direction;
	FVector3 up;
	FVector3 right;

	// orientation with angles
	FVector3 angles;

	// orientation with quaternion
	FQuaternion orientation;

	GameObject(gameObjectTypes_e gameObjectType);
	virtual ~GameObject();

	// Game interface
	virtual void attach(Game* game);
	virtual void detach();
	virtual bool isAttached() const;
	virtual Game* getGame() const;
	virtual void update( float deltaT );

	// Physics interface
	virtual void prepareForSimulationStep();
	virtual void updateAfterSimulationStep();
	virtual bool collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact);
	virtual bool collidedWithTerrain(const FVector3& contactPoint, dContact& contact);
	virtual void addLinearImpulse( const FVector3& impulse, const FVector3& position );
	virtual void addAngularImpulse( const FVector3& impulse );

	virtual void damage( float amount );
	virtual void heal( float amount );
	virtual void explode();

	gameObjectTypes_e getGameObjectType() const;

protected:
	Game* game;

	gameObjectTypes_e gameObjectType;

	float turnSpeed;
	float moveSpeed;

};


#endif // __GameObject_h__
