#ifndef __GeometryFactory_h__
#define __GeometryFactory_h__

#include <map>
#include <vector>
#include <string>
using namespace std;

class Geometry;
class Game;


class GeometryFactory{
public:
	GeometryFactory(Game* game);
	~GeometryFactory();

	void addGeometry(const string& geometryFilePath);
	void removeGeometry(const string& name);

	Geometry* createGeometry(const string& name) const;
	void destroyGeometry(Geometry* geometry) const;

	bool isGeometryAvailable( const string& name ) const;
	vector<string> getGeometryNames() const;

protected:
	Game* game;

	typedef map<string, Geometry*> geometriesByName_t;
	geometriesByName_t geometriesByName;

};

#endif // __GeometryFactory_h__
