#ifndef __Graphics_h__
#define __Graphics_h__

#include <Ogre.h>

#include <string>
using namespace std;

#include "SubSystem.h"
#include "CVar.h"

class Console;


class Graphics: public SubSystem{
public:

	struct stats_s{
		float lastFPS;
		float bestFPS;
		float worstFPS;
		float averageFPS;
		int triangleCount;
	};

	Graphics(System* system);
	~Graphics();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	struct cVars_s{
		CVarBool* graphics_shadowsEnabled;
		CVarBool* graphics_forceOgreConfigDialog;
	};
	cVars_s cVars;

	void update();

	void setSceneManagerByType( Ogre::SceneTypeMask sceneTypeMask );
	void setShadowTechnique( Ogre::ShadowTechnique newShadowTechnique );

	Ogre::Root* getOgreRoot() const;
	Ogre::RenderWindow* getRenderWindow() const;
	Ogre::Viewport* getMainViewport() const;
	Ogre::SceneManager* getSceneManager() const;
	Ogre::Camera* getMainCamera() const;

	void setShadowsEnabled(bool newShadowsEnabled);
	bool getShadowsEnabled() const;
	const stats_s& getStats() const;

protected:
	Ogre::Root* ogreRoot;
	Ogre::RenderWindow* renderWindow;
	Ogre::Viewport* mainViewport;
	Ogre::SceneManager* sceneManager;
	Ogre::Camera* mainCamera;

	Ogre::ShadowTechnique shadowTechnique;
	bool shadowsEnabled;
	bool forceOgreConfigDialog;

	unsigned long lastUpdateMillis;

	stats_s stats;
	void updateStats();
	void resetStats();

	void setupOgreResources( const string& ogreResourcesFilePath );
	void configureOgre();
	void createOgrePluginConfigFile( const string& path );
//	void createFrameListener();
//	void destroyFrameListener();
	void createMainViewport();
	void destroyMainViewport();
};

#endif // __Graphics_h__
