#include "GuiCCmds.h"

#include "System.h"
#include "Gui.h"
#include "ConsoleMenu.h"
#include "MainMenu.h"

CCmdGuiToggle::CCmdGuiToggle(): CCmd("gui.toggle"){
	this->usageString = "gui.toggle";
	this->infoString = "toggles the graphical user interface";
}
CCmdGuiToggle::~CCmdGuiToggle(){
}

void CCmdGuiToggle::exec( const vector<string>& arguments ){
	if( arguments.size() == 0 ){
		System::getInstance()->getGui()->toggleVisibility();
	}else{
		System::log("gui.toggle: usage: %s", usageString.c_str());
		return;
	}
}

CCmdGuiToggleConsole::CCmdGuiToggleConsole(): CCmd("gui.toggleConsole"){
	usageString = "gui.toggleConsole";
	infoString = "toggles the console window";
}
CCmdGuiToggleConsole::~CCmdGuiToggleConsole(){
}

void CCmdGuiToggleConsole::exec( const vector<string>& arguments ){
	if( arguments.size() == 0 ){
		System::getInstance()->getGui()->getConsoleMenu()->toggleVisibility();
	}else{
		System::log("gui.toggleConsole: usage: %s", usageString.c_str());
		return;
	}
}

CCmdGuiToggleMainMenu::CCmdGuiToggleMainMenu(): CCmd("gui.toggleMainMenu"){
	usageString = "gui.toggleMainMenu";
	infoString = "toggles the main menu";
}
CCmdGuiToggleMainMenu::~CCmdGuiToggleMainMenu(){
}

void CCmdGuiToggleMainMenu::exec( const vector<string>& arguments ){
	if( arguments.size() == 0 ){
		System::getInstance()->getGui()->getMainMenu()->toggleVisibility();
	}else{
		System::log("gui.toggleMainMenu: usage: %s", usageString.c_str());
		return;
	}
}









