#ifndef __Hovercraft_h__
#define __Hovercraft_h__

#include "Vehicle.h"

class Hovercraft: public Vehicle{
public:
	Hovercraft();
	~Hovercraft();

	virtual Vehicle* clone() const;
	virtual void reset();

	virtual void takeOverClientState( const Client::state_s& clientState );
	virtual void fillInClientState( Client::state_s& clientState ) const;

	virtual void processInput(Input::actionMap_t& actionMap, Input::mouseState_t& mouseState);

	virtual void prepareForSimulationStep();
	virtual void updateAfterSimulationStep();

	virtual bool collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact);
	virtual bool collidedWithTerrain(const FVector3& contactPoint, dContact& contact);

protected:
	float mainUnitYaw;
	float mainUnitPitch;

	bool hovering;
};

#endif // __Hovercraft_h__
