#ifndef __Hud_h__
#define __Hud_h__

#include <Ogre.h>

#include <string>
using namespace std;

class Gui;

class Hud{
public:
	Hud(Gui* gui);
	~Hud();

	void show();
	void hide();
	bool isVisible() const;

	void update();

	void showMarkers();
	void hideMarkers();

	void setCenterOfScreenMessage( const string& newCenterOfScreenMessage, unsigned long durationMillis = 5000 );

protected:
	Gui* gui;
	unsigned long centerOfScreenMessageExpireMillis;

	Ogre::Overlay* coreOverlay;
	Ogre::OverlayElement* crosshair;
	Ogre::OverlayElement* centerOfScreenMessage;
	Ogre::OverlayElement* status;
	Ogre::OverlayElement* healthBar;
	Ogre::OverlayElement* energyBar;
	struct weaponInfo_s {
		Ogre::OverlayElement* panel;
		Ogre::OverlayElement* icon;
		Ogre::OverlayElement* heatIndicator;
		Ogre::OverlayElement* ammoIndicator;
	} weaponInfos[4];


	Ogre::Overlay* teamStatusOverlay;
	struct teamStatusEntry_s {
		Ogre::OverlayElement* panel;
		Ogre::OverlayElement* healthBar;
		Ogre::OverlayElement* name;
	} teamStatusEntries[16];

	
	Ogre::Overlay* playerMarkersOverlay;
	struct playerMarker_s {
		Ogre::OverlayElement* rectangle;
		Ogre::OverlayElement* topText;
		Ogre::OverlayElement* bottomText;
	} playerMarkers[16];

	Ogre::Overlay* conquestAreaMarkersOverlay;
	struct conquestAreaMarker_s {
		Ogre::OverlayElement* rectangle;
		Ogre::OverlayElement* topText;
		Ogre::OverlayElement* bottomText;
	} conquestAreaMarkers[16];

	void updateCenterOfScreenMessage();
	void updateStatusBar();
	void updateTeamStatus();
	void updatePlayerMarkers();
	void updateConquestAreaMarkers();
};

#endif // __Hud_h__
