#include "Input.h"

#include "System.h"
#include "Exception.h"
#include "Console.h"
#include "InputListener.h"
#include "Graphics.h"
#include "Game.h"
#include "Camera.h"

//#include <SDL_syswm.h>

#include "main.h"
// Necessary to get the Window Handle of the window
//  Ogre created, so SDL can grab its input.
//#if FWP_PLATFORM == FWP_PLATFORM_WIN32
//#include <windows.h>
//#include <SDL_getenv.h>
//#endif






Input::Input(System* system): SubSystem(system){
//	this->ogreEventProcessor = NULL;
	this->inputListener = NULL;
	this->mouseState.sensitivity = 10.0f;
}

Input::~Input(){
}

void Input::initialize(){
	System::log("");
	System::log("*** Initializing Input ***");
	System::log("");

	System::log("Input: Initializing Keyboard...");
	initializeKeyboard();
	System::log("Input: Initializing Mouse...");
	initializeMouse();
	System::log("Input: Initializing ActionMap...");
	initializeActionMap();

	System::log("Input: Setting default bindings...");
	this->setDefaultBindings();

	this->inputMode = INPUT_MODE_GUI;

	this->initialized = true;
	System::log("Input is ready.");
	System::log("");

}

void Input::shutdown(){
	System::log("");
	System::log("=== Shutting down Input ===");
	System::log("");

	this->initialized = false;
	System::log("Input is down.");
	System::log("");


}
void Input::registerCCmds( Console& console ){
	cCmds.input_bind = new CCmdInputBind();
	console.registerCCmd( cCmds.input_bind );

	cCmds.input_unbind = new CCmdInputUnbind();
	console.registerCCmd( cCmds.input_unbind );

}
void Input::unregisterCCmds( Console& console ){
	console.unregisterCCmd( cCmds.input_bind );
	delete cCmds.input_bind;

	console.unregisterCCmd( cCmds.input_unbind );
	delete cCmds.input_unbind;
}
void Input::registerCVars( Console& console ){
	cVars.input_mouse_sensitivity = new CVarReal("input.mouse.sensitivity", &this->mouseState.sensitivity, true);
	cVars.input_mouse_sensitivity->setFlags( CVar::FLAG_SYSTEM );
	console.registerCVar(cVars.input_mouse_sensitivity);
}
void Input::unregisterCVars( Console& console ){
	console.unregisterCVar(cVars.input_mouse_sensitivity);
	delete cVars.input_mouse_sensitivity;
}


void Input::createInputListener(){

	this->inputListener = new InputListener(this);
	Ogre::RenderWindow* renderWindow = this->system->getGraphics()->getRenderWindow();

	ogreEventProcessor = new Ogre::EventProcessor();
	ogreEventProcessor->initialise(renderWindow);
//	ogreInputReader = ogreEventProcessor->getInputReader();

	ogreEventProcessor->addKeyListener(inputListener);
	ogreEventProcessor->addMouseListener(inputListener);
	ogreEventProcessor->addMouseMotionListener(inputListener);

	ogreEventProcessor->startProcessingEvents();

/*
	// Init OI
	Ogre::RenderWindow* window = this->system->getGraphics()->getRenderWindow();
	HWND hWnd;
	window->getCustomAttribute("HWND", &hWnd);
	HWND hWnd2 = FindWindow((LPCWSTR)"Fight Win Prevail", 0);
	char csw[64];
    sprintf(csw, "c:%u s:%u w:%u", 0, 0, hWnd);
    printf("win32test: init parameters '%s'\n", csw);
	printf("HWND2: %u\n", hWnd2);
    int e = oi_init(csw, 0);
    fprintf(stderr, "win32test: oi_init, code %i\n", e);
	//printf("isRinnung: %i", oi_is_running());
*/
/*
#if FWP_PLATFORM == FWP_PLATFORM_WIN32
	Ogre::RenderWindow* window = this->system->getGraphics()->getRenderWindow();
	HWND hWnd;
	char tmp[128];
	window->getCustomAttribute("HWND", &hWnd);
	// Set the SDL_WINDOWID environment variable
	sprintf(tmp, "SDL_WINDOWID=%d", (unsigned int)hWnd);
	_putenv(tmp);
#endif

	SDL_InitSubSystem(SDL_INIT_VIDEO | SDL_INIT_NOPARACHUTE);

#if FWP_PLATFORM == FWP_PLATFORM_WIN32
	SDL_SetVideoMode(window->getWidth(), window->getHeight(), 0, 0);

	SDL_SysWMinfo pInfo;
	SDL_VERSION(&pInfo.version);
	SDL_GetWMInfo(&pInfo);
	RECT r;
	GetWindowRect(pInfo.window, &r);
	SetWindowPos(pInfo.window, 0, r.left, r.top, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
#endif

	SDL_ShowCursor(SDL_DISABLE);
	//SDL_WM_GrabInput(SDL_GRAB_ON);
*/
}

void Input::destroyInputListener(){
	ogreEventProcessor->stopProcessingEvents();

	ogreEventProcessor->removeKeyListener(inputListener);
	ogreEventProcessor->removeMouseListener(inputListener);
	ogreEventProcessor->removeMouseMotionListener(inputListener);

	delete this->inputListener;
	this->inputListener = NULL;
	delete this->ogreEventProcessor;
	ogreEventProcessor = NULL;

	//	oi_close();
//	delete this->inputListener;
//	SDL_QuitSubSystem(SDL_INIT_VIDEO);
}




void Input::processInput(){
	int i;

//	this->inputListener->pollEvents();

	if( this->inputMode == INPUT_MODE_GAME ){
		for(i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
			if( keyMap[i].pressed && keyMap[i].boundAction != AC_NOACTION ){
				actionMap[keyMap[i].boundAction].triggered = true;
			}else{
				actionMap[keyMap[i].boundAction].triggered = false;
			}

			if( keyMap[i].clicked ){
				if( keyMap[i].boundParseString.length() != 0 ){
					this->system->getConsole()->parse( keyMap[i].boundParseString );
				}
//				if( keyMap[i].boundAction != AC_NOACTION ){
//					actionMap[keyMap[i].boundAction].triggered = false;
//				}
				keyMap[i].clicked = false;
			}
		}

		for(i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
			if( mouseState.buttonMap[i].pressed && mouseState.buttonMap[i].boundAction != AC_NOACTION ){
				actionMap[mouseState.buttonMap[i].boundAction].triggered = true;
			}else{
				actionMap[mouseState.buttonMap[i].boundAction].triggered = false;
			}

			if( mouseState.buttonMap[i].clicked ){
				if( mouseState.buttonMap[i].boundParseString.length() != 0 ){
					this->system->getConsole()->parse( mouseState.buttonMap[i].boundParseString );
				}
				mouseState.buttonMap[i].clicked = false;
			}
		}

		if( this->system->getGame()->isRunning() ){
			this->system->getGame()->processInput(actionMap, mouseState);
		}else{
			Camera* camera = this->system->getGame()->getCamera();
			camera->processInput( this->actionMap, this->mouseState );
			float deltaT = this->system->getTimer()->getDeltaT();
			camera->update( deltaT );
		}

	}else if( this->inputMode == INPUT_MODE_GUI ){
		// This is done in InputListener
	}

	// neutralize 'clicked' fields
	for(i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
		if( keyMap[i].clicked ){
			keyMap[i].clicked = false;
		}
	}
	for(i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
		if( mouseState.buttonMap[i].clicked ){
			mouseState.buttonMap[i].clicked = false;
		}
	}

//	System::log("xRel: %.2f, yRel: %.2f\n", mouseState.xRel, mouseState.yAbs);
	mouseState.xRel = 0.0f;
	mouseState.yRel = 0.0f;
}




void Input::bindActionToKey(actionCode_t action, keyCode_t key){
	keyMap[key].boundAction = action;
}
void Input::bindParseStringToKey(const string& parseString, keyCode_t key){
	keyMap[key].boundParseString = parseString;
}
void Input::bindActionToMouseButton(actionCode_t action, mouseButtonCode_t button){
	mouseState.buttonMap[button].boundAction = action;
}
void Input::bindParseStringToMouseButton(const string& parseString, mouseButtonCode_t button){
	mouseState.buttonMap[button].boundParseString = parseString;
}

void Input::unbindKey(keyCode_t keyCode){
	keyMap[keyCode].boundAction = AC_NOACTION;
	keyMap[keyCode].boundParseString = "";
}
void Input::unbindMouseButton(mouseButtonCode_t mouseButtonCode){
	mouseState.buttonMap[mouseButtonCode].boundAction = AC_NOACTION;
	mouseState.buttonMap[mouseButtonCode].boundParseString = "";
}
void Input::unbindAll(){
	int i;

	for(i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
		unbindKey( (keyCode_t)i );
	}

	for(i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
		unbindMouseButton( (mouseButtonCode_t)i );
	}

}

void Input::setDefaultBindings(){
	this->unbindAll();

	this->bindActionToKey(AC_MOVE_FORWARD, KC_W);
	this->bindActionToKey(AC_MOVE_BACKWARD, KC_S);
	this->bindActionToKey(AC_MOVE_LEFT, KC_A);
	this->bindActionToKey(AC_MOVE_RIGHT, KC_D);
	this->bindActionToKey(AC_MOVE_UP, KC_SPACE);
	this->bindActionToKey(AC_MOVE_DOWN, KC_LCTRL);

	this->bindActionToKey(AC_TURN_UP, KC_UP);
	this->bindActionToKey(AC_TURN_DOWN, KC_DOWN);
	this->bindActionToKey(AC_TURN_LEFT, KC_LEFT);
	this->bindActionToKey(AC_TURN_RIGHT, KC_RIGHT);

	this->bindActionToKey(AC_ROLL_LEFT, KC_Q);
	this->bindActionToKey(AC_ROLL_RIGHT, KC_E);

	this->bindActionToMouseButton(AC_FIRE1, MBC_LEFTBUTTON);
	this->bindActionToMouseButton(AC_FIRE2, MBC_RIGHTBUTTON);
	this->bindActionToMouseButton(AC_FIRE3, MBC_MIDDLEBUTTON);
	this->bindActionToKey(AC_FIRE4, KC_LALT);

	this->bindActionToKey(AC_ACTIVATE_BOOSTERS, KC_LSHIFT);
	this->bindActionToKey(AC_ALIGN_UNITS, KC_TAB);
	this->bindActionToKey(AC_RECOVER, KC_BACKSPACE);

	this->bindParseStringToKey("toggle gui.hud.drawMarkers", KC_R);
	this->bindParseStringToKey("toggle game.camera.mode", KC_C);
	this->bindParseStringToKey("game.kill", KC_K);
	this->bindParseStringToKey("game.chatAll", KC_Y);
	this->bindParseStringToKey("game.chatTeam", KC_T);
}

void Input::writeBindingsToFile( File& file ) const {
	int i;
	for(i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
		if( this->keyMap[i].boundAction != AC_NOACTION ){
			file.writeLine("input.bind " + this->keyMap[i].name + " \"" + this->actionMap[ this->keyMap[i].boundAction ].name + "\"");
		}else if( this->keyMap[i].boundParseString.length() != 0 ){
			file.writeLine("input.bind " + this->keyMap[i].name + " \"" + this->keyMap[i].boundParseString + "\"");
		}
	}

	file.writeLine("");


	for(i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
		if( this->mouseState.buttonMap[i].boundAction != AC_NOACTION ){
			file.writeLine("input.bind " + this->mouseState.buttonMap[i].name + " \"" + this->actionMap[ this->mouseState.buttonMap[i].boundAction ].name + "\"");
		}else if( this->mouseState.buttonMap[i].boundParseString.length() != 0 ){
			file.writeLine("input.bind " + this->mouseState.buttonMap[i].name + " \"" + this->mouseState.buttonMap[i].boundParseString + "\"");
		}
	}
}


void Input::initializeKeyboard(){
	clearKeyMap();

	// init names
	for(int i = 0; i < KC_NUM_KEY_CODES; i++){
		char buff[32];
		sprintf(buff, "key %i", i);
		keyMap[i].name = string(buff);
	}

	// ascii mapped keys
	keyMap[KC_BACKSPACE].name = "backspace";
	keyMap[KC_TAB].name = "tab";
//	keyMap[KC_CLEAR].name = "clear";
	keyMap[KC_RETURN].name = "return";
	keyMap[KC_PAUSE].name = "pause";
	keyMap[KC_ESCAPE].name = "escape";
	keyMap[KC_SPACE].name = "space";
/*	keyMap[KC_EXCLAIM].name = "exclaim";
	keyMap[KC_QUOTEDBL].name = "quotedbl";
	keyMap[KC_HASH].name = "hash";
	keyMap[KC_DOLLAR].name = "dollar";
	keyMap[KC_AMPERSAND].name = "ampersand";
	keyMap[KC_QUOTE].name = "quote";
	keyMap[KC_LEFTPAREN].name = "leftparen";
	keyMap[KC_RIGHTPAREN].name = "rightparen";
	keyMap[KC_ASTERISK].name = "asterisk";
	keyMap[KC_PLUS].name = "plus";
	keyMap[KC_COMMA].name = "comma";
	keyMap[KC_MINUS].name = "minus";
	keyMap[KC_PERIOD].name = "period";
	keyMap[KC_SLASH].name = "slash";
*/	keyMap[KC_0].name = "0";
	keyMap[KC_1].name = "1";
	keyMap[KC_2].name = "2";
	keyMap[KC_3].name = "3";
	keyMap[KC_4].name = "4";
	keyMap[KC_5].name = "5";
	keyMap[KC_6].name = "6";
	keyMap[KC_7].name = "7";
	keyMap[KC_8].name = "8";
	keyMap[KC_9].name = "9";
/*	keyMap[KC_COLON].name = "colon";
	keyMap[KC_SEMICOLON].name = "semicolon";
	keyMap[KC_LESS].name = "less";
	keyMap[KC_EQUALS].name = "equals";
	keyMap[KC_GREATER].name = "greater";
	keyMap[KC_QUESTION].name = "question";
	keyMap[KC_AT].name = "at";
*/	// skip uppercase letters
/*	keyMap[KC_LEFTBRACKET].name = "leftbracket";
	keyMap[KC_BACKSLASH].name = "backslash";
	keyMap[KC_RIGHTBRACKET].name = "rightbracket";
	keyMap[KC_CARET].name = "caret";
	keyMap[KC_UNDERSCORE].name = "underscore";
	keyMap[KC_BACKQUOTE].name = "backquote";
*/	keyMap[KC_A].name = "a";
	keyMap[KC_B].name = "b";
	keyMap[KC_C].name = "c";
	keyMap[KC_D].name = "d";
	keyMap[KC_E].name = "e";
	keyMap[KC_F].name = "f";
	keyMap[KC_G].name = "g";
	keyMap[KC_H].name = "h";
	keyMap[KC_I].name = "i";
	keyMap[KC_J].name = "j";
	keyMap[KC_K].name = "k";
	keyMap[KC_L].name = "l";
	keyMap[KC_M].name = "m";
	keyMap[KC_N].name = "n";
	keyMap[KC_O].name = "o";
	keyMap[KC_P].name = "p";
	keyMap[KC_Q].name = "q";
	keyMap[KC_R].name = "r";
	keyMap[KC_S].name = "s";
	keyMap[KC_T].name = "t";
	keyMap[KC_U].name = "u";
	keyMap[KC_V].name = "v";
	keyMap[KC_W].name = "w";
	keyMap[KC_X].name = "x";
	keyMap[KC_Y].name = "y";
	keyMap[KC_Z].name = "z";
	keyMap[KC_DELETE].name = "delete";
	// end of ascii mapped keys
	// skip international keyboard syms
	// numeric keypad
/*	keyMap[KC_KP0].name = "kp_0";
	keyMap[KC_KP1].name = "kp_1";
	keyMap[KC_KP2].name = "kp_2";
	keyMap[KC_KP3].name = "kp_3";
	keyMap[KC_KP4].name = "kp_4";
	keyMap[KC_KP5].name = "kp_5";
	keyMap[KC_KP6].name = "kp_6";
	keyMap[KC_KP7].name = "kp_7";
	keyMap[KC_KP8].name = "kp_8";
	keyMap[KC_KP9].name = "kp_9";
	keyMap[KC_KP_PERIOD].name = "kp_period";
	keyMap[KC_KP_DIVIDE].name = "kp_divide";
	keyMap[KC_KP_MULTIPLY].name = "kp_multiply";
	keyMap[KC_KP_MINUS].name = "kp_minus";
	keyMap[KC_KP_PLUS].name = "kp_plus";
	keyMap[KC_KP_ENTER].name = "kp_enter";
	keyMap[KC_KP_EQUALS].name = "kp_equals";
*/	// arrows + Home/End pad
	keyMap[KC_UP].name = "up";
	keyMap[KC_DOWN].name = "down";
	keyMap[KC_RIGHT].name = "right";
	keyMap[KC_LEFT].name = "left";
	keyMap[KC_INSERT].name = "insert";
	keyMap[KC_HOME].name = "home";
	keyMap[KC_END].name = "end";
	keyMap[KC_PAGEUP].name = "pageup";
	keyMap[KC_PAGEDOWN].name = "pagedown";
	// function keys
	keyMap[KC_F1].name = "f1";
	keyMap[KC_F2].name = "f2";
	keyMap[KC_F3].name = "f3";
	keyMap[KC_F4].name = "f4";
	keyMap[KC_F5].name = "f5";
	keyMap[KC_F6].name = "f6";
	keyMap[KC_F7].name = "f7";
	keyMap[KC_F8].name = "f8";
	keyMap[KC_F9].name = "f9";
	keyMap[KC_F10].name = "f10";
	keyMap[KC_F11].name = "f11";
	keyMap[KC_F12].name = "f12";
	keyMap[KC_F13].name = "f13";
	keyMap[KC_F14].name = "f14";
	keyMap[KC_F15].name = "f15";
	// key state modifier keys
	keyMap[KC_NUMLOCK].name = "numlock";
	keyMap[KC_CAPSLOCK].name = "capslock";
	keyMap[KC_SCROLLOCK].name = "scrollock";
	keyMap[KC_RSHIFT].name = "rshift";
	keyMap[KC_LSHIFT].name = "lshift";
	keyMap[KC_RCTRL].name = "rctrl";
	keyMap[KC_LCTRL].name = "lctrl";
	keyMap[KC_RALT].name = "ralt";
	keyMap[KC_LALT].name = "lalt";
/*	keyMap[KC_RMETA].name = "rmeta";
	keyMap[KC_LMETA].name = "lmeta";
	keyMap[KC_LSUPER].name = "lsuper";
	keyMap[KC_RSUPER].name = "rsuper";
	keyMap[KC_MODE].name = "mode";
	keyMap[KC_COMPOSE].name = "compose";
*/	// miscellaneous function keys
/*	keyMap[KC_HELP].name = "help";
	keyMap[KC_PRINT].name = "print";
	keyMap[KC_SYSREQ].name = "sysreq";
	keyMap[KC_BREAK].name = "break";
	keyMap[KC_MENU].name = "menu";
	keyMap[KC_POWER].name = "power";
	keyMap[KC_EURO].name = "euro";
	keyMap[KC_UNDO].name = "undo";
*/
}

void Input::clearKeyMap(){
	for(int i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
		keyMap[i].pressed = false;
		keyMap[i].clicked = false;
		keyMap[i].boundAction = AC_NOACTION;
		keyMap[i].boundParseString.clear();
	}
}


void Input::initializeMouse(){
	clearMouseButtonMap();

	mouseState.sensitivity = 10.0f;

	mouseState.buttonMap[MBC_LEFTBUTTON].name = "mouse_leftbutton";
	mouseState.buttonMap[MBC_RIGHTBUTTON].name = "mouse_rightbutton";
	mouseState.buttonMap[MBC_MIDDLEBUTTON].name = "mouse_middlebutton";
	mouseState.buttonMap[MBC_WHEELUP].name = "mouse_wheelup";
	mouseState.buttonMap[MBC_WHEELDOWN].name = "mouse_wheeldown";
}

void Input::clearMouseButtonMap(){
	for(int i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
		mouseState.buttonMap[i].pressed = false;
		mouseState.buttonMap[i].clicked = false;
		mouseState.buttonMap[i].boundAction = AC_NOACTION;
		mouseState.buttonMap[i].boundParseString.clear();
	}
}


void Input::initializeActionMap(){
	clearActionMap();

	actionMap[AC_NOACTION].name = "noaction";

	actionMap[AC_TURN_LEFT].name = "turn_left";
	actionMap[AC_TURN_RIGHT].name = "turn_right";
	actionMap[AC_TURN_UP].name = "turn_up";
	actionMap[AC_TURN_DOWN].name = "turn_down";

	actionMap[AC_MOVE_LEFT].name = "move_left";
	actionMap[AC_MOVE_RIGHT].name = "move_right";
	actionMap[AC_MOVE_UP].name = "move_up";
	actionMap[AC_MOVE_DOWN].name = "move_down";
	actionMap[AC_MOVE_FORWARD].name = "move_forward";
	actionMap[AC_MOVE_BACKWARD].name = "move_backward";

	actionMap[AC_ROLL_LEFT].name = "roll_left";
	actionMap[AC_ROLL_RIGHT].name = "roll_right";

	actionMap[AC_FIRE1].name = "fire1";
	actionMap[AC_FIRE2].name = "fire2";
	actionMap[AC_FIRE3].name = "fire3";
	actionMap[AC_FIRE4].name = "fire4";

	actionMap[AC_ACTIVATE_BOOSTERS].name = "activate_boosters";
	actionMap[AC_ALIGN_UNITS].name = "align_units";
	actionMap[AC_RECOVER].name = "recover";

	actionMap[AC_DEBUG1].name = "debug1";
}
void Input::clearActionMap(){
	for(int i=AC_NOACTION; i<AC_NUM_ACTION_CODES; i++){
		actionMap[i].triggered = false;
	}
}



Input::inputMode_t Input::getInputMode() const{
	return this->inputMode;
}
void Input::setInputMode(inputMode_t newInputMode){
	this->inputMode = newInputMode;
	if( this->inputMode == INPUT_MODE_GAME ){
//		oi_app_grab(OI_ENABLE);
//		SDL_EnableUNICODE(0);
//		oi_key_repeat( 0, 0 );
	}else{
//		oi_app_grab(OI_ENABLE);
//		SDL_EnableUNICODE(1);
//		oi_key_repeat( 1000, 100 );

	}
}

Input::keyCode_t Input::getKeyCodeByName(const string& name) const{
	for(int i=KC_NOKEY; i<KC_NUM_KEY_CODES; i++){
		if( keyMap[i].name == name ){
			return (keyCode_t)i;
		}
	}

	return KC_NOKEY;
}
Input::mouseButtonCode_t Input::getMouseButtonCodeByName(const string& name) const{
	for(int i=MBC_NOBUTTON; i<MBC_NUM_MOUSE_BUTTON_CODES; i++){
		if( mouseState.buttonMap[i].name == name ){
			return (mouseButtonCode_t)i;
		}
	}

	return MBC_NOBUTTON;
}
Input::actionCode_t Input::getActionCodeByName(const string& name) const{
	for(int i=AC_NOACTION; i<AC_NUM_ACTION_CODES; i++){
		if( actionMap[i].name == name ){
			return (actionCode_t)i;
		}
	}

	return AC_NOACTION;
}




