#ifndef __Input_h__
#define __Input_h__

#include "SubSystem.h"
#include "InputCCmds.h"
#include "CVar.h"
#include "File.h"

#include <string>
using namespace std;

#include <Ogre.h>

#include <OgreNoMemoryMacros.h>
#include <CEGUI.h>
#include <OgreMemoryMacros.h>

//#include <openinput.h>

class InputListener;
class Console;



class Input: public SubSystem{
	friend class InputListener;

public:

	typedef enum inputModes_e{
		INPUT_MODE_GAME,
		INPUT_MODE_GUI
	}inputMode_t;

	typedef enum actionCodes_e{
		AC_NOACTION = 0,

		AC_TURN_LEFT,
		AC_TURN_RIGHT,
		AC_TURN_UP,
		AC_TURN_DOWN,
		AC_MOVE_LEFT,
		AC_MOVE_RIGHT,
		AC_MOVE_UP,
		AC_MOVE_DOWN,
		AC_MOVE_FORWARD,
		AC_MOVE_BACKWARD,
		AC_ROLL_LEFT,
		AC_ROLL_RIGHT,

		AC_FIRE1,
		AC_FIRE2,
		AC_FIRE3,
		AC_FIRE4,

		AC_ACTIVATE_BOOSTERS,
		AC_ALIGN_UNITS,
		AC_RECOVER,

		AC_DEBUG1,

		AC_NUM_ACTION_CODES
	}actionCode_t;
	typedef struct actionMapElement_s{
		string name;
		bool triggered;
	}actionMapElement_t;
	typedef actionMapElement_t actionMap_t[AC_NUM_ACTION_CODES];

	// ogre keycoed
	typedef enum keyCodes_e{
		KC_NOKEY = 0,
        KC_ESCAPE          =0x01,
        KC_1               =0x02,
        KC_2               =0x03,
        KC_3               =0x04,
        KC_4               =0x05,
        KC_5               =0x06,
        KC_6               =0x07,
        KC_7               =0x08,
        KC_8               =0x09,
        KC_9               =0x0A,
        KC_0               =0x0B,
        KC_MINUS           =0x0C,    /* - on main keyboard */
        KC_EQUALS          =0x0D,
        KC_BACKSPACE            =0x0E,    /* backspace */
        KC_TAB             =0x0F,
        KC_Q               =0x10,
        KC_W               =0x11,
        KC_E               =0x12,
        KC_R               =0x13,
        KC_T               =0x14,
        KC_Y               =0x15,
        KC_U               =0x16,
        KC_I               =0x17,
        KC_O               =0x18,
        KC_P               =0x19,
        KC_LBRACKET        =0x1A,
        KC_RBRACKET        =0x1B,
        KC_RETURN          =0x1C,    /* Enter on main keyboard */
        KC_LCTRL        =0x1D,
        KC_A               =0x1E,
        KC_S               =0x1F,
        KC_D               =0x20,
        KC_F               =0x21,
        KC_G               =0x22,
        KC_H               =0x23,
        KC_J               =0x24,
        KC_K               =0x25,
        KC_L               =0x26,
        KC_SEMICOLON       =0x27,
        KC_APOSTROPHE      =0x28,
        KC_GRAVE           =0x29,    /* accent grave */
        KC_LSHIFT          =0x2A,
        KC_BACKSLASH       =0x2B,
        KC_Z               =0x2C,
        KC_X               =0x2D,
        KC_C               =0x2E,
        KC_V               =0x2F,
        KC_B               =0x30,
        KC_N               =0x31,
        KC_M               =0x32,
        KC_COMMA           =0x33,
        KC_PERIOD          =0x34,    /* . on main keyboard */
        KC_SLASH           =0x35,    /* '/' on main keyboard */
        KC_RSHIFT          =0x36,
        KC_MULTIPLY        =0x37,    /* * on numeric keypad */
        KC_LALT           =0x38,    /* left Alt */
        KC_SPACE           =0x39,
        KC_CAPSLOCK         =0x3A,
        KC_F1              =0x3B,
        KC_F2              =0x3C,
        KC_F3              =0x3D,
        KC_F4              =0x3E,
        KC_F5              =0x3F,
        KC_F6              =0x40,
        KC_F7              =0x41,
        KC_F8              =0x42,
        KC_F9              =0x43,
        KC_F10             =0x44,
        KC_NUMLOCK         =0x45,
        KC_SCROLLOCK          =0x46,    /* Scroll Lock */
        KC_NUMPAD7         =0x47,
        KC_NUMPAD8         =0x48,
        KC_NUMPAD9         =0x49,
        KC_SUBTRACT        =0x4A,    /* - on numeric keypad */
        KC_NUMPAD4         =0x4B,
        KC_NUMPAD5         =0x4C,
        KC_NUMPAD6         =0x4D,
        KC_ADD             =0x4E,    /* + on numeric keypad */
        KC_NUMPAD1         =0x4F,
        KC_NUMPAD2         =0x50,
        KC_NUMPAD3         =0x51,
        KC_NUMPAD0         =0x52,
        KC_DECIMAL         =0x53,    /* . on numeric keypad */
        KC_OEM_102         =0x56,    /* < > | on UK/Germany keyboards */
        KC_F11             =0x57,
        KC_F12             =0x58,
        KC_F13             =0x64,    /*                     (NEC PC98) */
        KC_F14             =0x65,    /*                     (NEC PC98) */
        KC_F15             =0x66,    /*                     (NEC PC98) */
        KC_KANA            =0x70,    /* (Japanese keyboard)            */
        KC_ABNT_C1         =0x73,    /* / ? on Portugese (Brazilian) keyboards */
        KC_CONVERT         =0x79,    /* (Japanese keyboard)            */
        KC_NOCONVERT       =0x7B,    /* (Japanese keyboard)            */
        KC_YEN             =0x7D,    /* (Japanese keyboard)            */
        KC_ABNT_C2         =0x7E,    /* Numpad . on Portugese (Brazilian) keyboards */
        KC_NUMPADEQUALS    =0x8D,    /* = on numeric keypad (NEC PC98) */
        KC_PREVTRACK       =0x90,    /* Previous Track (KC_CIRCUMFLEX on Japanese keyboard) */
        KC_AT              =0x91,    /*                     (NEC PC98) */
        KC_COLON           =0x92,    /*                     (NEC PC98) */
        KC_UNDERLINE       =0x93,    /*                     (NEC PC98) */
        KC_KANJI           =0x94,    /* (Japanese keyboard)            */
        KC_STOP            =0x95,    /*                     (NEC PC98) */
        KC_AX              =0x96,    /*                     (Japan AX) */
        KC_UNLABELED       =0x97,    /*                        (J3100) */
        KC_NEXTTRACK       =0x99,    /* Next Track */
        KC_NUMPADENTER     =0x9C,    /* Enter on numeric keypad */
        KC_RCTRL        =0x9D,
        KC_MUTE            =0xA0,    /* Mute */
        KC_CALCULATOR      =0xA1,    /* Calculator */
        KC_PLAYPAUSE       =0xA2,    /* Play / Pause */
        KC_MEDIASTOP       =0xA4,    /* Media Stop */
        KC_VOLUMEDOWN      =0xAE,    /* Volume - */
        KC_VOLUMEUP        =0xB0,    /* Volume + */
        KC_WEBHOME         =0xB2,    /* Web home */
        KC_NUMPADCOMMA     =0xB3,    /* , on numeric keypad (NEC PC98) */
        KC_DIVIDE          =0xB5,    /* / on numeric keypad */
        KC_SYSRQ           =0xB7,
        KC_RALT           =0xB8,    /* right Alt */
        KC_PAUSE           =0xC5,    /* Pause */
        KC_HOME            =0xC7,    /* Home on arrow keypad */
        KC_UP              =0xC8,    /* UpArrow on arrow keypad */
        KC_PAGEUP            =0xC9,    /* PgUp on arrow keypad */
        KC_LEFT            =0xCB,    /* LeftArrow on arrow keypad */
        KC_RIGHT           =0xCD,    /* RightArrow on arrow keypad */
        KC_END             =0xCF,    /* End on arrow keypad */
        KC_DOWN            =0xD0,    /* DownArrow on arrow keypad */
        KC_PAGEDOWN          =0xD1,    /* PgDn on arrow keypad */
        KC_INSERT          =0xD2,    /* Insert on arrow keypad */
        KC_DELETE          =0xD3,    /* Delete on arrow keypad */
        KC_LWIN            =0xDB,    /* Left Windows key */
        KC_RWIN            =0xDC,    /* Right Windows key */
        KC_APPS            =0xDD,    /* AppMenu key */
        KC_POWER           =0xDE,    /* System Power */
        KC_SLEEP           =0xDF,    /* System Sleep */
        KC_WAKE            =0xE3,    /* System Wake */
        KC_WEBSEARCH       =0xE5,    /* Web Search */
        KC_WEBFAVORITES    =0xE6,    /* Web Favorites */
        KC_WEBREFRESH      =0xE7,    /* Web Refresh */
        KC_WEBSTOP         =0xE8,    /* Web Stop */
        KC_WEBFORWARD      =0xE9,    /* Web Forward */
        KC_WEBBACK         =0xEA,    /* Web Back */
        KC_MYCOMPUTER      =0xEB,    /* My Computer */
        KC_MAIL            =0xEC,    /* Mail */
        KC_MEDIASELECT     =0xED,     /* Media Select */

		KC_NUM_KEY_CODES
	} keyCode_t;
/*	SDL / OI keycodes
	typedef enum keyCodes_e{
		KC_NOKEY = 0,

		// ascii mapped keys
		KC_BACKSPACE = 8,
		KC_TAB = 9,
		KC_CLEAR = 12,
		KC_RETURN = 13,
		KC_PAUSE = 19,
		KC_ESCAPE = 27,
		KC_SPACE = 32,
		KC_EXCLAIM = 33,
		KC_QUOTEDBL = 34,
		KC_HASH = 35,
		KC_DOLLAR = 36,
		KC_AMPERSAND = 38,
		KC_QUOTE = 39,
		KC_LEFTPAREN = 40,
		KC_RIGHTPAREN = 41,
		KC_ASTERISK = 42,
		KC_PLUS = 43,
		KC_COMMA = 44,
		KC_MINUS = 45,
		KC_PERIOD = 46,
		KC_SLASH = 47,
		KC_0 = 48,
		KC_1 = 49,
		KC_2 = 50,
		KC_3 = 51,
		KC_4 = 52,
		KC_5 = 53,
		KC_6 = 54,
		KC_7 = 55,
		KC_8 = 56,
		KC_9 = 57,
		KC_COLON = 58,
		KC_SEMICOLON = 59,
		KC_LESS = 60,
		KC_EQUALS = 61,
		KC_GREATER = 62,
		KC_QUESTION = 63,
		KC_AT = 64,

		// skip uppercase letters

		KC_LEFTBRACKET = 91,
		KC_BACKSLASH = 92,
		KC_RIGHTBRACKET = 93,
		KC_CARET = 94,
		KC_UNDERSCORE = 95,
		KC_BACKQUOTE = 96,
		KC_A = 97,
		KC_B = 98,
		KC_C = 99,
		KC_D = 100,
		KC_E = 101,
		KC_F = 102,
		KC_G = 103,
		KC_H = 104,
		KC_I = 105,
		KC_J = 106,
		KC_K = 107,
		KC_L = 108,
		KC_M = 109,
		KC_N = 110,
		KC_O = 111,
		KC_P = 112,
		KC_Q = 113,
		KC_R = 114,
		KC_S = 115,
		KC_T = 116,
		KC_U = 117,
		KC_V = 118,
		KC_W = 119,
		KC_X = 120,
		KC_Y = 121,
		KC_Z = 122,
		KC_DELETE = 127,
		// end of ascii mapped keys

		// skip international keyboard syms

		// numeric keypad
		KC_KP0 = 256,
		KC_KP1 = 257,
		KC_KP2 = 258,
		KC_KP3 = 259,
		KC_KP4 = 260,
		KC_KP5 = 261,
		KC_KP6 = 262,
		KC_KP7 = 263,
		KC_KP8 = 264,
		KC_KP9 = 265,
		KC_KP_PERIOD = 266,
		KC_KP_DIVIDE = 267,
		KC_KP_MULTIPLY = 268,
		KC_KP_MINUS = 269,
		KC_KP_PLUS = 270,
		KC_KP_ENTER = 271,
		KC_KP_EQUALS = 272,

		// arrows + Home/End pad
		KC_UP = 273,
		KC_DOWN = 274,
		KC_RIGHT = 275,
		KC_LEFT = 276,
		KC_INSERT = 277,
		KC_HOME = 278,
		KC_END = 279,
		KC_PAGEUP = 280,
		KC_PAGEDOWN = 281,

		// function keys
		KC_F1 = 282,
		KC_F2 = 283,
		KC_F3 = 284,
		KC_F4 = 285,
		KC_F5 = 286,
		KC_F6 = 287,
		KC_F7 = 288,
		KC_F8 = 289,
		KC_F9 = 290,
		KC_F10 = 291,
		KC_F11 = 292,
		KC_F12 = 293,
		KC_F13 = 294,
		KC_F14 = 295,
		KC_F15 = 296,

		// key state modifier keys
		KC_NUMLOCK = 300,
		KC_CAPSLOCK = 301,
		KC_SCROLLOCK = 302,
		KC_RSHIFT = 303,
		KC_LSHIFT = 304,
		KC_RCTRL = 305,
		KC_LCTRL = 306,
		KC_RALT = 307,
		KC_LALT = 308,
		KC_RMETA = 309,
		KC_LMETA = 310,
		KC_LSUPER = 311,
		KC_RSUPER = 312,
		KC_MODE = 313,
		KC_COMPOSE = 314,

		// miscellaneous function keys
		KC_HELP = 315,
		KC_PRINT = 316,
		KC_SYSREQ = 317,
		KC_BREAK = 318,
		KC_MENU = 319,
		KC_POWER = 320,
		KC_EURO = 321,
		KC_UNDO = 322,

		KC_NUM_KEY_CODES
	} keyCode_t;
	*/

	typedef struct keyMapElement_s{
		string name;
		bool pressed;
		bool clicked;
		actionCode_t boundAction;
		string boundParseString;
	} keyMapElement_t;
	typedef keyMapElement_t keyMap_t[KC_NUM_KEY_CODES];



	typedef enum mouseButtonCodes_e{
		MBC_NOBUTTON = 0,

		MBC_LEFTBUTTON = 1,
		MBC_RIGHTBUTTON = 2,
		MBC_MIDDLEBUTTON = 3,
		MBC_WHEELUP = 4,
		MBC_WHEELDOWN = 5,

		MBC_NUM_MOUSE_BUTTON_CODES
	} mouseButtonCode_t;

	typedef struct mouseButtonMapElement_s{
		string name;
		bool pressed;
		bool clicked;
		actionCode_t boundAction;
		string boundParseString;
	} mouseButtonElement_t;
	typedef mouseButtonElement_t mouseButtonMap_t[MBC_NUM_MOUSE_BUTTON_CODES];

	typedef struct mouseState_s{
		float xRel,yRel;
		float sensitivity;
		int xAbs, yAbs;
		mouseButtonMap_t buttonMap;
	} mouseState_t;




	Input(System* system);
	~Input();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	void createInputListener();
	void destroyInputListener();

	void bindActionToKey(actionCode_t action, keyCode_t key);
	void bindParseStringToKey(const string& parseString, keyCode_t key);
	void bindActionToMouseButton(actionCode_t action, mouseButtonCode_t button);
	void bindParseStringToMouseButton(const string& parseString, mouseButtonCode_t button);

	void unbindKey(keyCode_t keyCode);
	void unbindMouseButton(mouseButtonCode_t mouseButtonCode);
	void unbindAll();
	void setDefaultBindings();
	void writeBindingsToFile( File& file ) const;

	void clearKeyMap();
	void clearMouseButtonMap();
	void processInput();

	void clearActionMap();


	inputMode_t getInputMode() const;
	void setInputMode(inputMode_t newInputMode);

	keyCode_t getKeyCodeByName(const string& name) const;
	mouseButtonCode_t getMouseButtonCodeByName(const string& name) const;
	actionCode_t getActionCodeByName(const string& name) const;


protected:
	inputMode_t inputMode;
	keyMap_t keyMap;
	mouseState_t mouseState;
	actionMap_t actionMap;

	Ogre::EventProcessor* ogreEventProcessor;
//	Ogre::InputReader* ogreInputReader;
	InputListener* inputListener;


	void initializeKeyboard();
	void initializeMouse();
	void initializeActionMap();

	struct cVars_s{
		CVarReal* input_mouse_sensitivity;
	};
	cVars_s cVars;
	struct cCmds_s{
		CCmdInputBind* input_bind;
		CCmdInputUnbind* input_unbind;
//		CCmdInputBindlist* input_bindlist;
	};
	cCmds_s cCmds;

};

#endif // __Input_h__
