#include "InputCCmds.h"

#include "Input.h"
#include "System.h"

CCmdInputBind :: CCmdInputBind(): CCmd("input.bind"){
	usageString = "input.bind [keyOrMouseButton] [actionOrCcmd]";
	infoString = "binds an action or a ccmd to a key or a mouse button";
}

CCmdInputBind::~CCmdInputBind(){
}

void CCmdInputBind::exec( const vector<string>& arguments){

	Input* input = System::getInstance()->getInput();

	if(arguments.size() == 2){
		Input::keyCode_t keyCode = input->getKeyCodeByName( arguments[0].c_str() );
		if(keyCode == Input::KC_NOKEY ){	// no key -> try mouseButton
			Input::mouseButtonCode_t mouseButtonCode = input->getMouseButtonCodeByName( arguments[0].c_str() );
			if( mouseButtonCode == Input::MBC_NOBUTTON ){	// no button -> failure
				System::log("input.bind: '%s' is not a valid key or mouse button", arguments[0].c_str() );
				return;
			}else{
				Input::actionCode_t actionCode = input->getActionCodeByName( arguments[1].c_str() );
				if(actionCode != Input::AC_NOACTION ){
					input->bindActionToMouseButton( actionCode, mouseButtonCode );
					System::log("input.bind: '%s' bound to '%s'.", arguments[1].c_str(), arguments[0].c_str() );
					return;
				}else{
					input->bindParseStringToMouseButton( arguments[1], mouseButtonCode );
					System::log("input.bind: '%s' bound to '%s'.", arguments[1].c_str(), arguments[0].c_str());
					return;
				}
			}
		}

		Input::actionCode_t actionCode = input->getActionCodeByName(arguments[1].c_str());

		if( actionCode != Input::AC_NOACTION ){
			input->bindActionToKey( actionCode, keyCode );
			System::log("input.bind: '%s' bound to '%s'.", arguments[1].c_str(), arguments[0].c_str());
			return;
		}else{
			input->bindParseStringToKey( arguments[1], keyCode );
			System::log("input.bind: '%s' bound to '%s'.", arguments[1].c_str(), arguments[0].c_str());
			return;
		}
	}else{
		System::log("input.bind: usage: %s", usageString.c_str() );
		return;
	}
}

CCmdInputUnbind::CCmdInputUnbind():CCmd("input.unbind"){
	usageString = "input.unbind [keyOrMouseButton] or input.unbind all";
	infoString = "unbinds a key or mouse button (or all keys)";
}

CCmdInputUnbind::~CCmdInputUnbind(){
}

void CCmdInputUnbind::exec(const vector<string>& arguments){
	Input* input = System::getInstance()->getInput();

	if( arguments.size() == 1 ){
		if( arguments[0] == "all"){
			input->unbindAll();
			System::log("input.unbind: all keys and mouse buttons unbound.");
			return;
		}

		// unbind ONE key/button
		Input::keyCode_t keyCode = input->getKeyCodeByName( arguments[0] );
		if( keyCode == Input::KC_NOKEY ){	// no key -> try mouseButton
			Input::mouseButtonCode_t mouseButtonCode = input->getMouseButtonCodeByName( arguments[0] );
			if( mouseButtonCode == Input::MBC_NOBUTTON ){	// no button -> failure
				System::log("input.unbind: '%s' is not a valid key or mouse button", arguments[0].c_str() );
				return;
			}else{
				input->unbindMouseButton(mouseButtonCode);
				System::log("'%s' unbound.", arguments[0].c_str() );
				return;
			}
		}else{	// unbind key
			input->unbindKey(keyCode);
			System::log("input.unbind: '%s' unbound.", arguments[0].c_str() );
			return;
		}
	}else{
		System::log("input.unbind: usage: %s", usageString.c_str() );
		return;
	}
}

/*
CCmdInputBindlist::CCmdInputBindlist():CCmd("input.bindlist"){
	usageStr="input.bindlist";
	infoStr="gives a list with all current bindings";
}

CCmdInputBindlist::~CCmdInputBindlist(){
	if(console!=NULL)
		console->unregisterCCmd(this);
}

bool CCmdInputBindlist::exec(int argc, char* argv[]){
	if(argc==0){
		console->print("This will be included in the next release...\n");	// TODO
		return true;
	}else{
		console->print("usage: %s\n", usageStr);
		return false;
	}
}
*/
