#include "Logging.h"

#include "System.h"
#include "Exception.h"

#include <iostream>


Logging::Logging(System* system): SubSystem(system){
}

Logging::~Logging(){
}

void Logging::initialize(){

//#if FWP_PLATFORM == FWP_PLATFORM_WIN32
//	showWin32Console();
//#endif
	System::log("");
	System::log("*** Initializing Logging ***");
	System::log("");

	string logFilePath = this->system->getLogDir() + "fwp.log";
	logFileStream.open( logFilePath.c_str(), ios::out );
	if( !logFileStream.is_open() ){
		throw Exception("Couldn't open logFileStream ('" + logFilePath + "')", "Logging::initialize()");
	}
	System::log("Logging: Logging to '%s'.", logFilePath.c_str() );

	logFileStream << "Logfile for FWP (" << logFilePath << ")." << endl;
	logFileStream << "Warnings in this file are marked with [WARNING], errors with [ERROR] (so if you are searching for errors/warnings just search for these strings)." << endl;
	logFileStream << "Systeminfo: " << endl;
	logFileStream << "Platform: " << this->system->getPlatformString() << endl;
	logFileStream << "Version: " << this->system->getVersionString() << endl;
	logFileStream << "ConfigDir: " << this->system->getConfigDir() << endl;
	logFileStream << "DataDir: " << this->system->getDataDir() << endl;
	logFileStream << "LogDir: " << this->system->getLogDir() << endl;

	this->initialized = true;
	System::log("Logging is ready.");
	System::log("");

}

void Logging::shutdown(){
	System::log("");
	System::log("=== Shutting down Logging ===");
	System::log("");
	
	System::log("Logging: Closing logFileStream...");
	logFileStream.flush();
	logFileStream.close();

	this->initialized = false;
	System::log("Logging is down.");
	System::log("");

}

void Logging::registerCCmds( Console& console ){
}
void Logging::unregisterCCmds( Console& console ){
}
void Logging::registerCVars( Console& console ){
}
void Logging::unregisterCVars( Console& console ){
}




void Logging::log( const string& str ){

//	cout << str << endl;

	if( logFileStream.is_open() ){
		logFileStream << str << endl;
	}
}


/*
void Logging::showWin32Console(){
	WORD MAX_CONSOLE_LINES = 500;
	int hConHandle;
	long lStdHandle;
	CONSOLE_SCREEN_BUFFER_INFO coninfo;
	FILE *fp;
	// allocate a console for this app
	AllocConsole();
	// set the screen buffer to be big enough to let us scroll text
	GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE), &coninfo);
	coninfo.dwSize.Y = MAX_CONSOLE_LINES;
	SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE),
	coninfo.dwSize);
	// redirect unbuffered STDOUT to the console
	lStdHandle = (long)GetStdHandle(STD_OUTPUT_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen( hConHandle, "w" );
	*stdout = *fp;
	setvbuf( stdout, NULL, _IONBF, 0 );
	// redirect unbuffered STDIN to the console
	lStdHandle = (long)GetStdHandle(STD_INPUT_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen( hConHandle, "r" );
	*stdin = *fp;
	setvbuf( stdin, NULL, _IONBF, 0 );
	// redirect unbuffered STDERR to the console
	lStdHandle = (long)GetStdHandle(STD_ERROR_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen( hConHandle, "w" );
	*stderr = *fp;
	setvbuf( stderr, NULL, _IONBF, 0 );
	// make cout, wcout, cin, wcin, wcerr, cerr, wclog and clog
	// point to console as well
	std::ios::sync_with_stdio();
}
*/
