#ifndef __MessageBoxMenu_h__
#define __MessageBoxMenu_h__

#include "Menu.h"

class MessageBoxMenu: public Menu{
public:

	MessageBoxMenu(Gui* gui);
	~MessageBoxMenu();

	void show();
	void show(const string& title, const string& message, const string& buttonText);
	void hide();

	void registerEventHandlers();
	
	void setButtonClickedCallback(void (*function)(void*), void* object);
protected:
	string title;
	string message;
	string buttonText;
	void* buttonClickedCallbackObject;
	void (*buttonClickedCallbackFunction)(void*);

	CEGUI::MultiLineEditbox* messageMultiLineEditbox;
	CEGUI::PushButton* button;

	bool handleButtonClicked(const CEGUI::EventArgs& e);
};


#endif // __MessageBoxMenu_h__
