#include "MessagesMenu.h"

#include "System.h"
#include "StringConverter.h"
#include "Gui.h"
#include "Input.h"
#include "Network.h"
#include "Client.h"

const int MessagesMenu::MAX_MESSAGES = 5;
const unsigned long MessagesMenu::MESSAGE_LIFE_TIME_MILLIS = 5000;

MessagesMenu::MessagesMenu(Gui* gui): Menu(gui, "messages_menu.layout.xml") {
	this->messages.clear();

	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	this->textPanel = static_cast<CEGUI::StaticText*>( wmgr.getWindow( "GuiSheet/MessagesMenuWindow/TextPanel" ) );
	for( int i=0; i<MessagesMenu::MAX_MESSAGES; i++ ){
		this->entries[i] = static_cast<CEGUI::StaticText*>(
			wmgr.getWindow( "GuiSheet/MessagesMenuWindow/TextPanel/Entry" + StringConverter::toString(i) )
			);
	}

	this->composePanel = static_cast<CEGUI::StaticText*>( wmgr.getWindow( "GuiSheet/MessagesMenuWindow/ComposePanel" ) );
	this->composeEditbox = static_cast<CEGUI::Editbox*>( wmgr.getWindow( "GuiSheet/MessagesMenuWindow/ComposePanel/Editbox" ) );
	this->composeLabel = static_cast<CEGUI::StaticText*>( wmgr.getWindow( "GuiSheet/MessagesMenuWindow/ComposePanel/Label" ) );

	this->chatMode = ChatMessagePacket::MODE_ALL;
}

MessagesMenu::~MessagesMenu(){
}

void MessagesMenu::show(){
//	Game* game = this->gui->getSystem()->getGame();
//	if( !game->isRunning() ){
//		return;
//	}

	Menu::show();

	this->hideComposePanel();

	this->updateAppearance();

	// init gui elements
//	this->summaryText->setText( "Arschloch" );
}

void MessagesMenu::hide(){
	Menu::hide();

	this->messages.clear();
}


void MessagesMenu::registerEventHandlers(){
	this->composeEditbox->subscribeEvent(
			CEGUI::Editbox::EventTextAccepted,
			CEGUI::Event::Subscriber( &MessagesMenu::handleComposeEditboxTextAccepted, this )
		);
}


void MessagesMenu::showComposePanel( ChatMessagePacket::modes_e chatMode ){
	this->chatMode = chatMode;
	if( this->chatMode == ChatMessagePacket::MODE_TEAM ){
		this->composeLabel->setText( "[TEAM]" );
	}else{
		this->composeLabel->setText( "[ALL]" );
	}

	this->composeEditbox->setText("");
	this->composeEditbox->activate();

	this->composePanel->show();

	this->gui->getSystem()->getInput()->setInputMode( Input::INPUT_MODE_GUI );

	this->updateAppearance();
}
void MessagesMenu::hideComposePanel(){
	this->composeEditbox->setText("");
	this->composeEditbox->deactivate();

	this->composePanel->hide();

	this->gui->getSystem()->getInput()->setInputMode( Input::INPUT_MODE_GAME );

	this->updateAppearance();
}
bool MessagesMenu::isComposePanelVisible() const {
	return this->composePanel->isVisible();
}

void MessagesMenu::addMessage( const string& message, const FColor& color ){
	message_s m;

	m.text = message;
	m.color = color;
	m.addedMillis = this->gui->getSystem()->getTimer()->getMilliseconds();


	if( this->messages.size() == (unsigned int)MessagesMenu::MAX_MESSAGES ){
		this->messages.pop_front();
	}

	this->messages.push_back( m );

	if( this->isVisible() ){
		this->updateAppearance();
	}

}

void MessagesMenu::update(){
	unsigned long currentMillis = this->gui->getSystem()->getTimer()->getMilliseconds();

	if( this->messages.size() > 0 
		&& currentMillis > this->messages.front().addedMillis + MessagesMenu::MESSAGE_LIFE_TIME_MILLIS ){

		this->messages.pop_front();

		this->updateAppearance();
	}
}



void MessagesMenu::updateAppearance(){
	int i;

	for( i=0; i<MessagesMenu::MAX_MESSAGES; i++ ){
		this->entries[i]->hide();
	}

	int numMessages = this->messages.size();
	int availableSlots = MessagesMenu::MAX_MESSAGES + 1;

	if( this->isComposePanelVisible() ){
		CEGUI::Vector2 pos = CEGUI::Vector2( 0.0f, numMessages/(float)availableSlots + 0.005f );
		this->composePanel->setPosition( pos );
	}


	if( numMessages > 0 ){

		CEGUI::Size panelSize( 1.0f, numMessages/(float)availableSlots );// = this->ceguiWindow->screenToWindow( CEGUI::Size(0.7f*1024, numMessages*0.1f*768 + 0.2f) );
		this->textPanel->setSize( panelSize );

		int entryCounter = 0;
		for( messages_t::const_iterator c_iter = this->messages.begin(); c_iter != this->messages.end(); ++c_iter ){
			CEGUI::Size size = CEGUI::Size( 1.0f, 1.0f/numMessages );
			CEGUI::Vector2 pos = CEGUI::Vector2( 0.005f, entryCounter/(float)numMessages );

			this->entries[entryCounter]->setPosition( pos );
			this->entries[entryCounter]->setSize( size );
			this->entries[entryCounter]->setText( c_iter->text );
			this->entries[entryCounter]->setTextColours( c_iter->color.toCeguiColour() );

			this->entries[entryCounter]->show();
//			printf("entry %i: %s\n", entryCounter, c_iter->text.c_str());
			entryCounter++;
		}

		this->textPanel->show();
	}else{
		this->textPanel->hide();
	}

}

bool MessagesMenu::handleComposeEditboxTextAccepted(const CEGUI::EventArgs& e){

	string message( this->composeEditbox->getText().c_str() );

//	System::log( "chat: %s", message.c_str() );
	if( message.length() > 0 ){
		this->gui->getSystem()->getNetwork()->getClient()->sendChatMessagePacket( message, this->chatMode );
	}

	this->hideComposePanel();

	return true;
}
