#ifndef __Physics_h__
#define __Physics_h__

#include "FVectors.h"
#include "FQuaternion.h"
#include "IntersectionQueries.h"

#include <ode/ode.h>
//#include <ode/odecpp.h>
//#include <ode/odecpp_collision.h>

class Game;

class Physics{
public:

	Physics( Game* game );
	~Physics();

	void createSpaces( int quadTreeLevels, const FVector3& min, const FVector3& max );
	void takeSimulationStep( float deltaT );

	RayIntersectionQuery* createRayIntersectionQuery();
	
	void setGravity( const FVector3& gravity );
	const FVector3& getGravity() const;
	const FVector3& getNormalizedGravity() const;
	void setCollideAgainstTerrain( bool newCollideAgainstTerrain );
	bool getCollideAgainstTerrain() const ;

	float getTerrainHeightAt( const FVector3& position );

	dWorldID getWorld() const;
	dSpaceID getStaticGeometrySpace() const;
	dSpaceID getDynamicGeometrySpace() const;
	dJointGroupID getContactJointGroup() const;
	Game* getGame() const;

	static float frictionToMu( float friction );

protected:
	Game* game;

	dWorldID world;
	dSpaceID staticGeometrySpace;
	dSpaceID dynamicGeometrySpace;
	dJointGroupID contactJointGroup;

	FVector3 gravity;
	FVector3 normalizedGravity;
	bool collideAgainstTerrain;

	void collisionDetection();
	void collideShots();
	void collideGeoms();
//	void createContactJoint( const dContact& contact );

	bool aabbIntersectsTerrain( const Ogre::AxisAlignedBox& aabb );
	void collideGeomsAgainstTerrain();

	static dNearCallback geomNearGeomCallback;
};


#endif // __Physics_h__
