#ifndef __RegenerationArea_h__
#define __RegenerationArea_h__

#include "Area.h"

class Vehicle;

class RegenerationArea: public Area {
public:
	static const unsigned long REGENERATION_INTERVAL;

	RegenerationArea();
	virtual ~RegenerationArea();

	virtual Area* clone() const;

	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;
	virtual void calculateChecksum();

	virtual void attach( Game* game );
	virtual void detach();

	virtual bool canAffectVehicle( Vehicle* vehicle ) const;
	virtual void affectVehicle( Vehicle* vehicle );

protected:
	unsigned int teamFlags;
	unsigned long lastRegenerationMillis;

	Ogre::SceneNode* sceneNode;
	Ogre::ParticleSystem* particleSystem;

};

#endif // __RegenerationArea_h__
