#include "ScoresMenu.h"

#include "System.h"
#include "Exception.h"
#include "StringConverter.h"
#include "Gui.h"
#include "Game.h"
#include "Network.h"
#include "Client.h"
#include "Server.h"
#include "Vehicle.h"

ScoresMenu::ScoresMenu(Gui* gui): Menu(gui, "scores_menu.layout.xml") {

	this->summaryText = static_cast<CEGUI::StaticText*>(
		CEGUI::WindowManager::getSingleton().getWindow( "GuiSheet/ScoresMenuWindow/SummaryText")
		);

	this->scoresMultiColumnList = static_cast<CEGUI::MultiColumnList*>(
		CEGUI::WindowManager::getSingleton().getWindow( "GuiSheet/ScoresMenuWindow/ScoresMultiColumnList")
		);
	this->scoresMultiColumnList->setSelectionMode( CEGUI::MultiColumnList::RowSingle );

	this->scoresMultiColumnList->addColumn("Name", 0, 0.35f);
	this->scoresMultiColumnList->addColumn("Team", 1, 0.15f);
	this->scoresMultiColumnList->addColumn("Vehicle", 2, 0.15f);
	this->scoresMultiColumnList->addColumn("Status", 3, 0.15f);
	this->scoresMultiColumnList->addColumn("Score", 4, 0.1f);
	this->scoresMultiColumnList->addColumn("Ping", 5, 0.1f);

	this->scoresMultiColumnList->addColumn("Deaths", 6, 0.1f);
	this->scoresMultiColumnList->addColumn("Kills", 7, 0.1f);
	this->scoresMultiColumnList->addColumn("Damage Inflicted", 8, 0.2f);
	this->scoresMultiColumnList->addColumn("Seconds on Server", 9, 0.2f);
	
}

ScoresMenu::~ScoresMenu(){
}

void ScoresMenu::show(){
	Game* game = this->gui->getSystem()->getGame();
	if( !game->isRunning() ){
		return;
	}

	Menu::show();

	// init gui elements
//	this->summaryText->setText( "Arschloch" );
}

void ScoresMenu::hide(){
	Menu::hide();

	this->scoresMultiColumnList->resetList();
}

void ScoresMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(	wmgr.getWindow("GuiSheet/ScoresMenuWindow") );

	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &ScoresMenu::handleCloseClicked, this )
		);

}


void ScoresMenu::update(){
	Network* network = this->gui->getSystem()->getNetwork();

	int maxClients = network->getServer()->properties.maxClients;
	Client** clientArray = network->getServer()->getClientArray();

	int redScore = 0;
	int blueScore = 0;
	int highestScore = -1000;
	string bestPlayer;

	// update list
	this->scoresMultiColumnList->resetList();
	for( int i=0; i<maxClients; i++ ){
		if( clientArray[i] != NULL ){
			Client* client = clientArray[i];
	
			if( client->info.score > highestScore ){
				highestScore = client->info.score;
				bestPlayer = client->properties.name;
			}
			if( client->info.team == Game::TEAM_RED ){
				redScore += client->info.score;
			}
			if( client->info.team == Game::TEAM_BLUE ){
				blueScore += client->info.score;
			}

			string name = client->properties.name;
			string team = Game::getTeamName( client->info.team );
			string vehicle = "<none>";
			string status = "<dead>";
			if( client->getVehicle() != NULL ){
				vehicle = client->getVehicle()->getName();
				status = StringConverter::toString( client->state.health ) + " / " + StringConverter::toString( client->getVehicle()->getPhysicalProperties().healthCapacity );
			}
			string score = StringConverter::toString( client->info.score );
			string ping = StringConverter::toString( client->info.ping );
			if( client->isConnectionInterrupted() ){
				ping = "<connection interrupted>";
			}
			string deaths = StringConverter::toString( client->info.deaths );
			string kills = StringConverter::toString( client->info.kills );
			string damageInflicted = StringConverter::toString( client->info.damageInflicted );
			string secondsOnServer = StringConverter::toString( client->info.secondsOnServer );

			int rowIndex = this->scoresMultiColumnList->addRow();
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( name ), 0, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( team ), 1, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( vehicle ), 2, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( status ), 3, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( score ), 4, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( ping ), 5, rowIndex);

			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( deaths ), 6, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( kills ), 7, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( damageInflicted ), 8, rowIndex);
			this->scoresMultiColumnList->setItem(new MultiColumnListboxItem( secondsOnServer ), 9, rowIndex);

			if( client == network->getClient() ){ // mark local client
				this->scoresMultiColumnList->setItemSelectState( CEGUI::MCLGridRef(rowIndex,0), true);
			}
		}
	}

	// update message
	Game* game = this->gui->getSystem()->getGame();
	string summaryText;
	if( game->isRunningTeamMode() ){
		if( redScore > blueScore ){
			summaryText = "RED leads with " + StringConverter::toString(redScore) + " to " + StringConverter::toString(blueScore) + " points.";
		}else if( blueScore > redScore ){
			summaryText = "BLUE leads with " + StringConverter::toString(blueScore) + " to " + StringConverter::toString(redScore) + " points.";
		}else{
			summaryText = "Teams are tied at " + StringConverter::toString(redScore) + " points.";
		}
	}else{
		summaryText = bestPlayer + " leads with " + StringConverter::toString(highestScore) + " points.";
	}

	this->summaryText->setText( summaryText );
}




bool ScoresMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}

