#ifndef __Server_h__
#define __Server_h__

#include "Packets.h"


#include <vector>
#include <string>
using namespace std;

class Network;
class Socket;
class Client;

class Server{

friend class Client;
friend class Network;

public:
	static const int DEFAULT_PORT;
	static const int DEFAULT_SERVER_STATE_INTERVAL;

	static const unsigned long SERVER_INFO_INTERVAL_MILLIS;
	static const unsigned long PING_INTERVAL_MILLIS;
	static const unsigned long MASTER_SERVER_UPDATE_INTERVAL_MILLIS;

	static const int MAX_SERVER_IDLE_TIME;
	static const int MAX_CLIENT_IDLE_TIME;

	struct properties_s{
		string name;
		string host;
		int port;
		int connectionSpeed;
		bool remote;
		bool registerOnMasterServer;

		Packet::ipAddress_t ipAddress;

		int maxClients;
		string arena;
		int gameMode;
		int ghostTime;

		vector< string > availableVehicles;
		vector< string > availableWeapons;
	} properties;

	struct info_s{ // things that change seldomly during a game
		int secondsRunning;

		int numClients;
	} info;

	Server( Network* network );
	~Server();

	void setUp();
	void tearDown();
	void update();

	void establishLoopbackConnection( Client* client );

	Client** getClientArray() const;
	Client* getClient( int slot ) const;

	const string& lookUpVehicleName( int index ) const;
	const string& lookUpWeaponName( int index ) const;

protected:
	Network* network;

	Socket* socket;

	Client** clients;

	ServerPropertiesPacket spp; // cached for faster sending
	ServerInfoPacket sip;

	unsigned long lastServerInfoMillis;
	unsigned long lastPingMillis;
	unsigned long lastMasterServerUpdateMillis;

	Packet::ipAddress_t masterServerIpAddress;
//	int packetsReceived;
//	int packetsSent;

	void disconnect( Client* client, const string& reason );
	void disconnectAll( const string& reason );

	string createValidClientName( const string& desiredName );
	void addClient( Client* client );
	void addClient( Client* client, int slot );
	void removeAndDestroyClient( int slot );
	void removeAndDestroyClient( Client* client );
	void removeAndDestroyAllRemoteClients();

	void acceptLoopbackConnection( Client* client );
	void acceptRemoteConnection( Client* client );

	void applyServerPropertiesPacket( ServerPropertiesPacket* spp );
	void applyServerInfoPacket( ServerInfoPacket* sip );
//	void applyServerStatePacket( ServerStatePacket* ssp );

	void receivePackets();
	void handleConnectPacket( ConnectPacket* cp );
	void handleDisconnectPacket( DisconnectPacket* dp );
	void handlePingPacket( PingPacket* pp );
	void handleSpawnPacket( SpawnPacket* sp );
	void handleKillPacket( KillPacket* kp );
	void handleFirePacket( FirePacket* fp );
	void handleChatMessagePacket( ChatMessagePacket* cmp );
	void handleClientStatePacket( ClientStatePacket* csp );
	void handleServerUpdateRequestPacket( ServerUpdateRequestPacket* surp );

	void sendPackets();
	void sendToAllClients( Packet* packet ) const;
	void sendServerPropertiesPacket( const Packet::ipAddress_t& ipAddress );
	void updateServerInfoPacket();
	void sendServerInfoPacket( const Packet::ipAddress_t& ipAddress );
//	void sendServerStatePacket();
};

#endif // __Server_h__
