#ifndef __ShotFactory_h__
#define __ShotFactory_h__

#include <map>
#include <vector>
#include <string>
using namespace std;

class Shot;
class Game;


class ShotFactory{
public:
	ShotFactory( Game* game );
	~ShotFactory();

	void addShot( const string& shotFilePath );
	void removeShot( const string& name );

	Shot* createShot( const string& name ) const;
	void destroyShot( Shot* shot ) const;

	bool isShotAvailable( const string& name ) const;
	vector<string> getShotNames() const;

protected:
	Game* game;

	typedef map<string, Shot*> shotsByName_t;
	shotsByName_t shotsByName;

};

#endif // __ShotFactory_h__
