#ifndef __Socket_h__
#define __Socket_h__

#include "Packets.h"

class Network;

class Socket{
public:
	static const int DEFAULT_NUM_PACKETS_PER_RECEIVE;

	Socket( Network* network, int port );
	~Socket();

	void open();
	void close();
	bool isOpen();

	void send(Packet* packet);
	void receive(Packet::packetList_t& packetlist, int maxPackets = DEFAULT_NUM_PACKETS_PER_RECEIVE, int dataBufferSize = Packet::GAME_PACKETS_MAX_DATA_BUFFER_SIZE);
	void emptyIncomingPacketQueue();

protected:
	UDPsocket udpSocket;
	int port;

	Network* network;
};



#endif // __Socket_h__
