#ifndef __SpawnArea_h__
#define __SpawnArea_h__

#include "Area.h"

class SpawnArea: public Area {
public:
	SpawnArea();
	virtual ~SpawnArea();

	virtual Area* clone() const;

	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;
	virtual void calculateChecksum();

	virtual void attach( Game* game );
	virtual void detach();

	bool isUsableForTeam( int team );
	FVector3 getSpawnPosition();

protected:
	unsigned int teamFlags;
};


#endif // __SpawnArea_h__
