#ifndef __StartServerMenu_h__
#define __StartServerMenu_h__

#include "Menu.h"

class StartServerMenu: public Menu{
public:
	StartServerMenu(Gui* gui);
	~StartServerMenu();

	void show();
	void registerEventHandlers();

protected:
	vector<string> arenaNames;

	CEGUI::Editbox* serverNameEditbox;
	CEGUI::Combobox* gameModeCombobox;
	CEGUI::Combobox* playerLimitCombobox;
	CEGUI::Listbox* arenaListbox;
	CEGUI::MultiLineEditbox* descriptionMultiLineEditbox;
	CEGUI::Checkbox* registerOnMasterServerCheckbox;

	bool handleCloseClicked(const CEGUI::EventArgs& e);
	bool handleStartServerButtonClicked(const CEGUI::EventArgs& e);
	bool handleExpertSettingsButtonClicked(const CEGUI::EventArgs& e);
	bool handleConfigureMasterServerButtonClicked(const CEGUI::EventArgs& e);

	bool handleArenaListboxSelectionChanged(const CEGUI::EventArgs& e);
};


#endif // __StartServerMenu_h__
