#include "StaticGeometry.h"

#include "Exception.h"
#include "System.h"
#include "Shot.h"
#include "Game.h"
#include "Graphics.h"

StaticGeometry::StaticGeometry(): Geometry( Geometry::GEOMETRY_TYPE_STATIC ) {

	this->staticGeometry = NULL;
	this->entity = NULL;
	this->sceneNode = NULL;
}

StaticGeometry::~StaticGeometry(){
}

void StaticGeometry::reset(){
}

Geometry* StaticGeometry::clone() const {
	StaticGeometry* ret = new StaticGeometry();

	*ret = *this;

	// TODO: copy ogreSceneNode, etc...
	ret->reset();

	return ret;
}

//void StaticGeometry::calculateChecksum(){
//	this->checksum = 0;
//}

void StaticGeometry::attach( Game* game ){
	if( this->game != NULL ){
		throw Exception("Geometry is already attached to a game.", "StaticGeometry::attach()");
	}

	this->instanceId = game->getNextId();
//	printf("id: %d\n", id);
	char tmp[512];
	sprintf(tmp, "effect '%s' (instance id: %d)", this->name.c_str(), this->instanceId);
	this->instanceName = string(tmp);

	Ogre::SceneManager* sm = game->getSystem()->getGraphics()->getSceneManager();
	Ogre::SceneNode* rootSceneNode = sm->getRootSceneNode();

	this->sceneNode = rootSceneNode->createChildSceneNode( this->instanceName + "/SceneNode" );
	this->sceneNode->setPosition( this->position.toOgreVector3() );
	this->sceneNode->setOrientation( this->orientation.toOgreQuaternion() );

	if( !this->graphicalProperties.mesh.empty() ){
		this->entity = sm->createEntity( this->instanceName + "/Entity", this->graphicalProperties.mesh );
		this->entity->setCastShadows( this->graphicalProperties.castShadows );
		this->sceneNode->attachObject( this->entity );
	}

	if( this->graphicalProperties.staticGeometry ){
		this->staticGeometry = sm->createStaticGeometry( this->instanceName + "/StaticGeometry" );
		this->staticGeometry->addSceneNode( this->sceneNode );
		this->staticGeometry->setCastShadows( this->graphicalProperties.castShadows );
		this->staticGeometry->build();

		rootSceneNode->removeAndDestroyChild( this->sceneNode->getName() );
		this->sceneNode = NULL;
	}else{
	}


	Physics* physics = game->getPhysics();
	this->physicalProperties.shape.createGeoms( this );
	this->physicalProperties.shape.setGeomsPosition( this->position );
	this->physicalProperties.shape.setGeomsOrientation( this->orientation );
	this->physicalProperties.shape.addGeomsToSpace( physics->getStaticGeometrySpace() );


	this->game = game;

}

void StaticGeometry::detach(){
	if( this->game == NULL ){
		throw Exception("Geometry is not attached to a game.", "StaticGeometry::detach()");
	}

	Physics* physics = this->game->getPhysics();
	this->physicalProperties.shape.removeGeomsFromSpace( physics->getStaticGeometrySpace() );
	this->physicalProperties.shape.destroyGeoms();

	Ogre::SceneManager* sm = this->game->getSystem()->getGraphics()->getSceneManager();

	if( this->staticGeometry != NULL ){
		sm->destroyStaticGeometry( this->staticGeometry );
		this->staticGeometry = NULL;
	}

	if( this->entity != NULL ){
		sm->destroyEntity( this->entity );
		this->entity = NULL;
	}

	if( this->sceneNode != NULL ){
		//sm->destroySceneNode( this->ogreSceneNode->getName() );
		this->sceneNode->getParentSceneNode()->removeAndDestroyChild( this->sceneNode->getName() );
		this->sceneNode = NULL;
	}


	this->game = NULL;
}


void StaticGeometry::update( float deltaT ){
}



void StaticGeometry::prepareForSimulationStep(){
}
void StaticGeometry::updateAfterSimulationStep(){
}


bool StaticGeometry::collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact){

	if( other == NULL ){
		return true;

	}else if( other->getGameObjectType() == GameObject::GAME_OBJECT_TYPE_SHOT ){
		return false;

	}else{
		contact.surface.mu += Physics::frictionToMu(this->physicalProperties.friction) * 0.5f;
		if( this->physicalProperties.bouncyness > 0.0f ){
			contact.surface.mode |= dContactBounce;
			contact.surface.bounce += this->physicalProperties.bouncyness*0.5f;
		}
		return true;
	}
}
bool StaticGeometry::collidedWithTerrain(const FVector3& contactPoint, dContact& contact){
	contact.surface.mu += Physics::frictionToMu(this->physicalProperties.friction) * 0.5f;
	if( this->physicalProperties.bouncyness > 0.0f ){
		contact.surface.mode |= dContactBounce;
		contact.surface.bounce += this->physicalProperties.bouncyness*0.5f;
	}
	return true;
}

void StaticGeometry::addLinearImpulse( const FVector3& impulse, const FVector3& position ){
}
void StaticGeometry::addAngularImpulse( const FVector3& impulse ){
}

void StaticGeometry::damage( float amount ){
}

void StaticGeometry::explode(){
}

bool StaticGeometry::shouldBeDetached() const {
	return false;
}


