#include "Timer.h"

#include "System.h"

#include <time.h>
//#include <SDL.h>
//#include <Ogre.h>

Timer::Timer(){
	this->ogreTimer = Ogre::PlatformManager::getSingleton().createTimer();

	this->deltaT = 0.0f;
	this->lastDeltaTCalculationMillis = this->ogreTimer->getMilliseconds();
}
Timer::~Timer(){
	Ogre::PlatformManager::getSingleton().destroyTimer(this->ogreTimer);
}

void Timer::reset(){
	this->ogreTimer->reset();
	this->deltaT = 0.0f;
	this->lastDeltaTCalculationMillis = this->ogreTimer->getMilliseconds();

//	this->lastDeltaTCalculationMillis = SDL_GetTicks();
//	this->lastResetMillis = SDL_GetTicks();
}

void Timer::setDeltaT(float newDeltaT){
	this->deltaT = newDeltaT;
}
float Timer::getDeltaT(){
	return this->deltaT;
}
void Timer::calculateDeltaT(){
	unsigned long currentMillis = this->ogreTimer->getMilliseconds();
//	unsigned long currentMillis = SDL_GetTicks();
	this->deltaT = (currentMillis - this->lastDeltaTCalculationMillis) / 1000.0f;
	this->lastDeltaTCalculationMillis = currentMillis;
}

unsigned long Timer::getMilliseconds(){
//	return (SDL_GetTicks() - this->lastResetMillis);
	return this->ogreTimer->getMilliseconds();
}

void Timer::delay( float milliseconds ){
	unsigned long enterMillis = this->getMilliseconds();
	unsigned long currentMillis = this->getMilliseconds();
	do{
		currentMillis = this->getMilliseconds();
	}while( currentMillis < enterMillis+milliseconds );
}


string Timer::getSystemTimeString(){
	time_t t = time( NULL );
	return ctime( &t );
}
