#ifndef __Vehicle_h__
#define __Vehicle_h__

#include "GameObject.h"
#include "Shape.h"
#include "Input.h"
#include "Client.h"

#include <tinyxml.h>

#include <string>
using namespace std;

class Camera;
class Effect;
class Weapon;

class Vehicle: public GameObject{

friend class Weapon;

public:

#define MAX_WEAPONS 4

	enum vehicleTypes_e{
		VEHICLE_TYPE_DRONE = 0,
		VEHICLE_TYPE_HOVERCRAFT,
		VEHICLE_TYPE_MECH,

		NUM_VEHICLE_TYPES
	};

	struct info_s{
		string description;
	};

	struct graphicalProperties_s{
		string propulsionUnitMesh;
		string mainUnitMesh;
		string propulsionEffect;
		string boosterEffect;
		string explosionEffect;

		FVector3 firstPersonViewPoint;
		FVector3 chaseViewPoint;
	};

	struct physicalProperties_s{
		bool affectedByGravity;
		float bouncyness;
		float friction;
//		surfaceTypes_e surfaceType;
		float propulsiveForce;
		float propulsiveTorque;
		float maxLinearVelocity;
		float maxAngularVelocity;
		float boosterForce;
		float hoverHeight;
		float airControlModifier;
		float minMainUnitYaw;
		float maxMainUnitYaw;
		float maxMainUnitPitch;
		float minMainUnitPitch;
		float energyCapacity;
		float healthCapacity;

		vector<FVector3> hoverPoints;
		dMass mass;
//		dBodyID body;
		Shape shape;

		vector<FVector3> weaponSlots;

		struct debris_s{
			string geometry;
			string effect;
			FVector3 initialPosition;
			FVector3 initialLinearImpulse;
			FVector3 initialAngularImpulse;
		};
		vector<debris_s> debris;
	};

	struct acousticalProperties_s{
		string engineHumSound;
	};


	Vehicle(vehicleTypes_e vehicleType);
	~Vehicle();

	virtual Vehicle* clone() const = 0;
	virtual void reset() = 0;

//	virtual void loadFromFile( const string& arenaFilePath );
	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;

	virtual void attach(Game* game, Client* client);
	virtual void detach();
	virtual void update( float deltaT );

	virtual void processInput(Input::actionMap_t& actionMap, Input::mouseState_t& mouseState);
	virtual void setupCamera(Camera* camera);

	virtual void takeOverClientState( const Client::state_s& clientState ) = 0;
	virtual void fillInClientState( Client::state_s& clientState ) const = 0;

	virtual bool collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact);
	virtual bool collidedWithTerrain(const FVector3& contactPoint, dContact& contact);

	virtual void addLinearImpulse( const FVector3& impulse, const FVector3& position );
	virtual void addAngularImpulse( const FVector3& impulse );

	virtual void damage( float amount );
	virtual void heal( float amount );
	virtual void explode();

	virtual void restockAmmoRel( float relAmount );
	virtual void thermalShock();

	virtual void setName( const string& newName );
	virtual const string& getName() const;
	virtual Client* getClient() const;
	virtual const string& getDescription() const;
//	virtual Game* getGame() const;
	virtual void calculateChecksum();
	virtual unsigned int getChecksum() const;
	vehicleTypes_e getVehicleType() const;
	const physicalProperties_s& getPhysicalProperties() const;
	Weapon* getWeapon(int slot) const;
	float getHealth() const;
	float getEnergy() const;
	void setAttackerClientId( int id );

protected:
	vehicleTypes_e vehicleType;

	info_s info;
	graphicalProperties_s graphicalProperties;
	physicalProperties_s physicalProperties;
	acousticalProperties_s acousticalProperties;

	string name;
	Client* client;
	Weapon* weapons[MAX_WEAPONS];

	unsigned int checksum;

	float health;
	float energy;
	dBodyID body;

	FVector3 propulsiveForce;
	FVector3 propulsiveTorque;

	bool boostersActive;
	bool recoveryActive;

	Ogre::SceneNode* mainUnitSceneNode;
	Ogre::Entity* mainUnitEntity;
	Ogre::SceneNode* propulsionUnitSceneNode;
	Ogre::Entity* propulsionUnitEntity;
	Effect* propulsionEffect;
	Effect* boosterEffect;

	int attackerClientId;

	virtual void setTeamMaterial( int team );

	virtual void parseInfo(TiXmlElement* infoElement);
	virtual void parseDescription(TiXmlElement* descriptionElement);
	virtual void parseGraphicalProperties( TiXmlElement* graphicalPropertiesElement );
	virtual void parsePhysicalProperties( TiXmlElement* physicalPropertiesElement );
	virtual void parseMass( TiXmlElement* massElement );
	virtual void parseDebris( TiXmlElement* debrisElement );
	virtual void parseAcousticalProperties( TiXmlElement* acousticalPropertiesElement );

//	virtual bool collidedWithShot( const FVector3& contactPoint, Shot* s, dContact& contact );

};

#endif // __Vehicle_h__
