#ifndef __WeaponFactory_h__
#define __WeaponFactory_h__

#include <map>
#include <vector>
#include <string>
using namespace std;

class Weapon;
class Game;


class WeaponFactory{
public:
	WeaponFactory( Game* game );
	~WeaponFactory();

	void addWeapon( const string& weaponFilePath );
	void removeWeapon( const string& name );

	Weapon* createWeapon( const string& name ) const;
	void destroyWeapon( Weapon* weapon ) const;

	bool isWeaponAvailable( const string& name ) const;
	vector<string> getWeaponNames() const;
	const string& getWeaponDescription( const string& name ) const;

protected:
	Game* game;

	typedef map<string, Weapon*> weaponsByName_t;
	weaponsByName_t weaponsByName;

};

#endif // __WeaponFactory_h__
