#include "main.h"

#include "System.h"
#include "Exception.h"

#include <iostream>


int main(int argc, char** argv){

	cout << "Creating System instance..." << endl;
	System::createInstance();

	cout << "Parsing command-line arguments..." << endl;
	if( argc > 1 ){	// parse command-line
		string arguments;
		for(int i=1;i<argc;i++){
			cout << "argv " << i << ": [" << argv[i] << "]" << endl;
			arguments = arguments + " " + string(argv[i]);
		}

		System::getInstance()->parseCommandLineArguments(arguments);
	}
	
	// THINKABOUTME: This kind of error handling sucks!
	try{
	try{
	try{
	try{
		System::getInstance()->initialize();
		System::getInstance()->mainLoop();
		System::getInstance()->shutdown();
	}catch( std::exception& e ){ throw Exception(e); }
	}catch( Ogre::Exception& e ){ throw Exception(e); }
	}catch( CEGUI::Exception& e ){ throw Exception(e); }

	}catch( Exception& e ){
		cerr << "Exiting due to an exception:" << endl;
		e.printFullInfo( cerr );
	
		System::deleteInstance();
		return -1;
	}
	
	cout << "Destroying System instance..." << endl;
	System::deleteInstance();

	cout << "Returning to operating system..." << endl;
	return 0;
}
