#ifndef __main_h__
#define __main_h__

#define FWP_PLATFORM_WIN32	1
#define FWP_PLATFORM_LINUX	2

// OS-dependent defines
#ifdef WIN32
// win32
#define FWP_PLATFORM			FWP_PLATFORM_WIN32
#define FWP_PLATFORM_STRING		"win32"
#define FWP_DEFAULT_DATA_DIR	"./data/"
#define FWP_DEFAULT_CONFIG_DIR	"./cfg/"
#define FWP_DEFAULT_LOG_DIR		"./"
#define OGRE_PLUGIN_DIR		"./win32/bin"

#else
// linux
#define FWP_PLATFORM			FWP_PLATFORM_LINUX
#define FWP_PLATFORM_STRING		"linux"

#ifndef FWP_DEFAULT_DATA_DIR	// maybe we got this from configure
#	define FWP_DEFAULT_DATA_DIR	"./data/"
#endif
#ifndef FWP_DEFAULT_CONFIG_DIR	// maybe we got this from configure
#	define FWP_DEFAULT_CONFIG_DIR	"./cfg/"
#endif
#ifndef FWP_DEFAULT_LOG_DIR		// maybe we got this from configure
#	define FWP_DEFAULT_LOG_DIR		"./"
#endif
#ifndef OGRE_PLUGIN_DIR		// maybe we got this from configure
#	define OGRE_PLUGIN_DIR		"/usr/local/lib/OGRE"
#endif

#endif
// end OS-dependent defines

#ifdef PACKAGE_VERSION
#	define FWP_VERSION_STRING PACKAGE_VERSION
#else
#	define FWP_VERSION_STRING "0.0.8"
#endif


#if defined(_MSC_VER) && (_MSC_VER <= 1200)
#   pragma warning(disable : 4786)
#endif


#endif // __main_h__
