/* A Bison parser, made from gaa_parser.y
   by GNU bison 1.32.  */

#define YYBISON 1  /* Identify Bison output.  */

#define YYLSP_NEEDED 1

# define	IDENTIFIER	257
# define	ACTION	258
# define	TERMINATE	259
# define	CSOURCE	260
# define	CPART	261
# define	TYPE	262
# define	STRING	263
# define	UNDERSCORE_STRINGS	264
# define	INIT	265
# define	DEFITEM	266
# define	OPTION	267
# define	REST	268
# define	HELPNODE	269
# define	OBLIGATORY	270
# define	INCOMPATIBLE	271
# define	DATA	272
# define	AS	273
# define	OPTIONAL	274

#line 1 "gaa_parser.y"

/*
 *      Copyright (C) 1998,1999 Joran Maille
 *      Copyright (C) 2002 Nikos Mavroyanopoulos
 *
 * This file is part of GAA-ng.
 *
 * GAA-ng is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GAA-ng is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "../config.h"

#include "gaaout.h"
    
#define NEW(x,first, tmp)              \
    tmp = (x*) malloc(sizeof(x));      \
    tmp->next = first;                 \
    first = tmp;

#define GAA_NOREST            -1
    
#define GAA_SINGLE            0
#define GAA_LIST              1

#define GAA_OBLIGAT           1
#define GAA_INCOMP            2
#define GAAMAX_ARGLIST_COUNT 30


#define LOOKUP(first, tmp,  id, key, _line)                                       \
    for(tmp = first; tmp != NULL; tmp = tmp->next)                                \
    {                                                                             \
        if(tmp->id == key)                                                        \
        {                                                                \
            fprintf(stderr, "%s:%d: identifier '%s' redefined\n", st_in, _line, num2str(key));  \
            fprintf(stderr, "%s:%d: this is the location of the previous definition\n", st_in, tmp->line);  \
            error_flag = 1;                                                        \
        }                                                                          \
    }

#define SUPERLOOKUP(id, key, line)                                                 \
    LOOKUP(first_option, option_tmp,  id, key, line);
    
FILE* glb_fd, *glb_skel;
FILE* glb_out;
FILE* glb_sfd; /* emulates stdin */

int glb_underscore_strings = 0;

int yyerror( char* s);  /* Called by yyparse on error */
int yylex();

int type = 0;
extern int num_lines; /* current line */
char* st_in; /* hold input_filename */

struct _option;
struct _option_argless;
struct _arg;
struct _type;
struct _help;
struct _struct_elt;

typedef struct _option option;
typedef struct _arg arg;
typedef struct _atype atype;
typedef struct _struct_elt struct_elt;
typedef struct _help help;
typedef struct _condition condition;


int k_needed = 0, init_loc = -1, rest_nb_arg = 0;
int error_flag = 0;

int rest_type = GAA_NOREST, rest_action = 0;
int c_code = 0;
int nb_option = 0, nb_option_argless = 0, nb_atype = 0, nb_struct_elt = 0, nb_help = 0;
option *option_tmp, *first_option = NULL;
atype *atype_tmp, *first_atype = NULL;
struct_elt *struct_elt_tmp, *first_struct_elt = NULL;
help *help_tmp, *first_help = NULL;
arg *arg_tmp, *first_rest_arg = NULL;
condition *condition_tmp, *first_condition = NULL;

char* num2str(int n);
int get_id_line(int n);

struct _help
{
    int str;
    int line;
    help *next;
};

help* get_help(int num)
{
    int i;
    help *tmp;
    tmp = first_help;
    for(i = 0; (i < num) && (tmp !=NULL); i++)
    tmp = tmp->next;
    if(tmp == NULL)
    {
        fprintf(stderr, "%s: '%d' out of range\n", st_in, num);
        exit(1);
    }
    return tmp;
}

struct _option
{
    int id1, id2;
    int action;
    int help;
    int nb_arg;
    arg *fa;
    int line;
    option *next;
};

option* get_option(int num)
{
    int i;
    option *tmp;
    tmp = first_option;
    for(i = 0; (i < num) && (tmp !=NULL); i++)
    tmp = tmp->next;
    if(tmp == NULL)
    {
        fprintf(stderr, "%s: '%d' out of range\n", st_in, num);
        exit(1);
    }
    return tmp;
}

struct _condition
{
    int type;
    int options;
    condition *next;
};


struct _arg
{
    int type;
    int help;
    int id;
    arg *next;
};

arg* get_arg(int numOpt, int num)
{
    int i;
    arg *tmp;
    tmp = (get_option(numOpt))->fa;
    for(i = 0; (i < num) && (tmp !=NULL); i++)
    tmp = tmp->next;
    if(tmp == NULL)
    {
        fprintf(stderr, "%s: '%d' out of range\n", st_in, num);
        exit(1);
    }
    return tmp;
}



struct _atype
{
    int id;
    int fnName;
    int argtype;
    int line;
    char* type_str;
    atype *next;
};

atype* get_atype(int num)
{
    int i;
    atype *tmp;
    tmp = first_atype;
    for(i = 0; (i < num) && (tmp !=NULL); i++)
    tmp = tmp->next;
    if(tmp == NULL)
    {
        fprintf(stderr, "%s: '%d' out of range\n", st_in, num);
        exit(1);
    }
    return tmp;
}
atype* get_atype_from_id(int num)
{
    int i;
    atype *tmp;
    tmp = first_atype;
    for(i = 0; (tmp!=NULL) && (tmp->id != num); i++) {
	    tmp = tmp->next;
    }
    if(tmp == NULL)
    {
        fprintf(stderr, "%s:%d: identifier '%s' out of range\n", st_in, 
		get_id_line(num), num2str(num));
        exit(1);
    }
    return tmp;
}

atype* get_type(arg *in)
{
    int i;
    atype *tmp = first_atype;
    for(i = 0; i < nb_atype; i++)
    {
        if(in->id == tmp->id)
            return tmp;
        tmp = tmp->next;
    }
    fprintf(stderr, "%s:%d: Unknown type '%s'.\n", st_in, num_lines - 1, num2str(in->id));
    exit(1);
}


struct _struct_elt
{
    int data; /* 0 for '#' statement, 1 for 'DATA' 'AS' statement */
    int type; /* only if data == 1  GAA_LIST / GAA_SINGLE */
    int id;   /* only if data == 1 */
    int arg_type; /* only if data == 1 */
    int location; /* only if data == 0 */
    struct_elt *next;
};

struct_elt* get_struct_elt(int num)
{
    int i;
    struct_elt *tmp;
    tmp = first_struct_elt;
    for(i = 0; (i < num) && (tmp !=NULL); i++)
    tmp = tmp->next;
    if(tmp == NULL)
    {
        printf("Out of range\n");
        exit(1);
    }
    return tmp;
};

void read_str(FILE* fd, int offset, char **target, char separator)
{
    int i, size = -1;
    int a;
    fseek(fd, offset, SEEK_SET);
    do
    {
        if( (a=fgetc( fd)) == EOF)
        {
            printf("Read error\n");
            exit(1);
        }
        size++;
    }
    while(a != separator);
    *target = malloc(size+1);
    fseek(fd, offset, SEEK_SET);
    for(i = 0; i < size; i++)
    {
        if( (a=fgetc(fd)) == EOF)
        {
            printf("Read error\n");
            exit(1);
        }
       (*target)[i] = a;
    }
    (*target)[size] = 0;
}

/* append is appended to the string output */
void copy_str(FILE* fd, int offset, FILE* out, const char* append)
{
    int a = '"', b, last = ' ';
    int flag;

    fseek(fd, offset-1, SEEK_SET);
    if( (a=fgetc(fd)) == EOF)
    {
        printf("Read error\n");
        exit(1);
    }
    while(a == '"' || a == '%')
    {
        b = a;
        if(a == '"') {
		if (glb_underscore_strings!=0) fputs("_(", out);
	        fprintf(out,"%c", '"');
	}
        flag = 1;
        do
        {
            if( (a=fgetc(fd)) == EOF)
            {
                printf("Read error\n");
                exit(1);
            }
            if((a == b) && (last != '\\'))
            {
                if(flag == 1)
                    flag = 0;
                else
                    flag = 1;
            }
            if((flag == 1) || (a == b && b != '%'))
            {
		if (a=='"' && append!=NULL) fputs( append, out);
                fprintf(out, "%c", a);
		if (a=='"' && glb_underscore_strings!=0) fputs(")", out);
	    }
            last = a;
        }
        while(flag == 1);
        do
        {
            if( (a=fgetc(fd)) == EOF)
            {
                return;
            }
        }
        while ((a == ' ' || a == '\r' || a == '\t' || a == '\n'));
    }
}

#ifndef YYSTYPE
#define YYSTYPE int
#endif

#ifndef YYLTYPE
typedef struct yyltype
{
  int first_line;
  int first_column;

  int last_line;
  int last_column;
} yyltype;

# define YYLTYPE yyltype
#endif

#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		55
#define	YYFLAG		-32768
#define	YYNTBASE	25

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 274 ? yytranslate[x] : 32)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      22,    23,    21,     2,    24,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    13,    15,    18,    19,
      21,    24,    27,    31,    33,    36,    38,    41,    43,    48,
      51,    54,    59,    67,    77,    81,    84,    87
};
static const short yyrhs[] =
{
      26,     5,     0,    26,     0,     6,    26,     0,    31,     0,
      26,    31,     0,     3,     0,    21,     3,     0,     0,    29,
       0,    20,    29,     0,    27,     9,     0,    27,     9,    29,
       0,    27,     0,    27,    29,     0,     9,     0,    30,     9,
       0,     7,     0,    18,     3,    19,    27,     0,    15,    30,
       0,    11,     4,     0,    12,     3,     3,     7,     0,    13,
      22,     3,    23,    28,     4,    30,     0,    13,    22,     3,
      24,     3,    23,    28,     4,    30,     0,    14,    28,     4,
       0,    16,     3,     0,    17,     3,     0,    10,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   375,   377,   378,   381,   383,   385,   390,   395,   400,
     405,   413,   420,   427,   434,   442,   446,   450,   458,   475,
     486,   487,   496,   539,   588,   612,   619,   626
};
#endif

#define YYNTOKENS 25
#define YYNNTS 7
#define YYNRULES 27
#define YYNSTATES 56
#define YYMAXUTOK 274

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "IDENTIFIER", "ACTION", "TERMINATE", 
  "CSOURCE", "CPART", "TYPE", "STRING", "UNDERSCORE_STRINGS", "\"init\"", 
  "\"defitem\"", "\"option\"", "\"rest\"", "\"helpnode\"", "\"obligat\"", 
  "\"incomp\"", "\"data\"", "\"as\"", "\"optional\"", "'*'", "'('", "')'", 
  "','", "input", "source", "arg", "arg_list", "arg_real_list", 
  "many_strings", "line", NULL
};
/* YYTOKNUM[YYLEX] -- Index in YYTNAME corresponding to YYLEX. */
static const short yytoknum[] =
{
       0,   256,     2,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    42,    40,    41,    44,    -1
};
/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    25,    25,    25,    26,    26,    27,    27,    28,    28,
      29,    29,    29,    29,    29,    30,    30,    31,    31,    31,
      31,    31,    31,    31,    31,    31,    31,    31
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     2,     1,     2,     1,     2,     1,     2,     0,     1,
       2,     2,     3,     1,     2,     1,     2,     1,     4,     2,
       2,     4,     7,     9,     3,     2,     2,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     0,    17,    27,     0,     0,     0,     8,     0,     0,
       0,     0,     2,     4,     3,    20,     0,     0,     6,     0,
       0,    13,     0,     9,    15,    19,    25,    26,     0,     1,
       5,     0,     0,    10,     7,    11,    14,    24,    16,     0,
      21,     8,     0,    12,    18,     0,     0,     0,     8,    22,
       0,     0,    23,     0,     0,     0
};

static const short yydefgoto[] =
{
      53,    12,    21,    22,    23,    25,    13
};

static const short yypact[] =
{
      30,    42,-32768,-32768,     7,     9,    -6,    -1,    16,    23,
      35,    36,    17,-32768,    42,-32768,    47,    48,-32768,    -1,
      58,    -3,    59,-32768,-32768,    53,-32768,-32768,    45,-32768,
  -32768,    60,   -19,-32768,-32768,    -1,-32768,-32768,-32768,     0,
  -32768,    -1,    62,-32768,-32768,    64,    43,    16,    -1,    53,
      65,    16,    53,    70,    71,-32768
};

static const short yypgoto[] =
{
  -32768,    72,    33,   -40,   -12,   -37,     1
};


#define	YYLAST		73


static const short yytable[] =
{
      18,    45,    18,    18,    41,    42,    35,    33,    50,    36,
      49,    15,    16,    30,    52,    30,    17,    19,    20,    19,
      20,    20,    29,    43,     2,    24,    26,     3,     4,     5,
       6,     7,     8,     9,    10,    11,     1,     2,    27,    28,
       3,     4,     5,     6,     7,     8,     9,    10,    11,     2,
      31,    32,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    34,    38,    37,    39,    46,    48,    40,    47,    51,
      54,    55,    44,    14
};

static const short yycheck[] =
{
       3,    41,     3,     3,    23,    24,     9,    19,    48,    21,
      47,     4,     3,    12,    51,    14,    22,    20,    21,    20,
      21,    21,     5,    35,     7,     9,     3,    10,    11,    12,
      13,    14,    15,    16,    17,    18,     6,     7,     3,     3,
      10,    11,    12,    13,    14,    15,    16,    17,    18,     7,
       3,     3,    10,    11,    12,    13,    14,    15,    16,    17,
      18,     3,     9,     4,    19,     3,    23,     7,     4,     4,
       0,     0,    39,     1
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#ifdef __cplusplus
# define YYSTD(x) std::x
#else
# define YYSTD(x) x
#endif

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
#  define YYSIZE_T YYSTD (size_t)
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#    define YYSIZE_T YYSTD (size_t)
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  ifdef __cplusplus
#   include <cstdlib> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T std::size_t
#  else
#   ifdef __STDC__
#    include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#    define YYSIZE_T size_t
#   endif
#  endif
#  define YYSTACK_ALLOC YYSTD (malloc)
#  define YYSTACK_FREE YYSTD (free)
# endif

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Relocate the TYPE STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Type, Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	yymemcpy ((char *) yyptr, (char *) (Stack),			\
		  yysize * (YYSIZE_T) sizeof (Type));			\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (Type) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# ifdef __cplusplus
#  include <cstddef> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T std::size_t
# else
#  ifdef __STDC__
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  ifdef __cplusplus
#   include <cstdio>  /* INFRINGES ON USER NAME SPACE */
#  else
#   include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYFPRINTF YYSTD (fprintf)
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace. [The following comment makes no
   sense to me.  Could someone clarify it?  --akim] Since this is
   uninitialized, it does not stop multiple parsers from coexisting.
   */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#if ! defined (yyoverflow) && ! defined (yymemcpy)
# if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#  define yymemcpy __builtin_memcpy
# else				/* not GNU C or C++ */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
#  if defined (__STDC__) || defined (__cplusplus)
yymemcpy (char *yyto, const char *yyfrom, YYSIZE_T yycount)
#  else
yymemcpy (yyto, yyfrom, yycount)
     char *yyto;
     const char *yyfrom;
     YYSIZE_T yycount;
#  endif
{
  register const char *yyf = yyfrom;
  register char *yyt = yyto;
  register YYSIZE_T yyi = yycount;

  while (yyi-- != 0)
    *yyt++ = *yyf++;
}
# endif
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 341 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# ifdef __cplusplus
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else /* !__cplusplus */
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif /* !__cplusplus */
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (short, yyss);
	YYSTACK_RELOCATE (YYSTYPE, yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (YYLTYPE, yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
#line 376 "gaa_parser.y"
{ c_code = yyvsp[0]; }
    break;
case 2:
#line 377 "gaa_parser.y"
{ c_code = -1; }
    break;
case 3:
#line 378 "gaa_parser.y"
{ c_code = yyvsp[-1]; }
    break;
case 6:
#line 387 "gaa_parser.y"
{
            yyval = yyvsp[0];
        }
    break;
case 7:
#line 391 "gaa_parser.y"
{
            yyval = -yyvsp[0];
        }
    break;
case 8:
#line 396 "gaa_parser.y"
{
        yyval = (int)malloc(sizeof(int));
        ((int*)yyval)[0] = 0;
        }
    break;
case 9:
#line 401 "gaa_parser.y"
{
            yyval = yyvsp[0];
        }
    break;
case 10:
#line 407 "gaa_parser.y"
{
	        yyval = yyvsp[0];
                ((int*)yyval)[0]++;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 1] = 0;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 2] = -1;
        }
    break;
case 11:
#line 414 "gaa_parser.y"
{
        	yyval = (int)malloc((2 * GAAMAX_ARGLIST_COUNT + 1)* sizeof(int));
                ((int*)yyval)[0] = 1;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 1] = yyvsp[-1];
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 2] = yyvsp[0];
        }
    break;
case 12:
#line 421 "gaa_parser.y"
{
        	yyval = yyvsp[0];
                ((int*)yyval)[0]++;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 1] = yyvsp[-2];
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 2] = yyvsp[-1];
        }
    break;
case 13:
#line 428 "gaa_parser.y"
{
        	yyval = (int)malloc((2 * GAAMAX_ARGLIST_COUNT + 1)* sizeof(int));
                ((int*)yyval)[0] = 1;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 1] = yyvsp[0];
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 2] = -1;
        }
    break;
case 14:
#line 435 "gaa_parser.y"
{
        	yyval = yyvsp[0];
                ((int*)yyval)[0]++;
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 1] = yyvsp[-1];
                ((int*)yyval)[2*(((int*)yyval)[0] - 1) + 2] = -1;
        }
    break;
case 15:
#line 443 "gaa_parser.y"
{
		yyval = yyvsp[0];
	}
    break;
case 16:
#line 446 "gaa_parser.y"
{
		yyval = yyvsp[-1];
	}
    break;
case 17:
#line 452 "gaa_parser.y"
{
            NEW(struct_elt, first_struct_elt, struct_elt_tmp);
            struct_elt_tmp->data = 0;
            struct_elt_tmp->location = yyvsp[0];
            nb_struct_elt++;
        }
    break;
case 18:
#line 459 "gaa_parser.y"
{
            NEW(struct_elt, first_struct_elt, struct_elt_tmp);
            struct_elt_tmp->data = 1;
            struct_elt_tmp->id = yyvsp[-2];
            if(yyvsp[0] < 0)
            {
                struct_elt_tmp->type = GAA_LIST;
                struct_elt_tmp->arg_type = -yyvsp[0];
            }
            else
            {
                struct_elt_tmp->type = GAA_SINGLE;
                struct_elt_tmp->arg_type = yyvsp[0];
            }
            nb_struct_elt++;
        }
    break;
case 19:
#line 476 "gaa_parser.y"
{
            NEW(help, first_help, help_tmp);
            help_tmp->str = yyvsp[0];
            help_tmp->line = yylsp[-1].first_line;
            nb_help++;
            
            fprintf(glb_out, "\tprintf(");
            copy_str(glb_fd, yyvsp[0], glb_out, "\\n");
            fprintf(glb_out, ");\n");
        }
    break;
case 20:
#line 486 "gaa_parser.y"
{ init_loc = yyvsp[0]; }
    break;
case 21:
#line 488 "gaa_parser.y"
{
            NEW(atype, first_atype, atype_tmp);
            atype_tmp->id = yyvsp[-2];
            atype_tmp->fnName = yyvsp[-1];
            atype_tmp->argtype = yyvsp[0];
            nb_atype++;

        }
    break;
case 22:
#line 497 "gaa_parser.y"
{
            int i, *tab, sent=0;
            SUPERLOOKUP(id2, yyvsp[-4], yylsp[-6].first_line);
            NEW(option, first_option, option_tmp);
            option_tmp->fa = NULL;
            option_tmp->id1 = 0;
            option_tmp->id2 = yyvsp[-4];
            option_tmp->action = yyvsp[-1];
            option_tmp->line = yylsp[-6].first_line;
            option_tmp->help = yyvsp[0];
            tab = (int*)yyvsp[-2];
            option_tmp->nb_arg = tab[0];
            nb_option++;

   	    fprintf(glb_out, "\t__gaa_helpsingle(0, \"%s\", ", num2str(yyvsp[-4]));

	    for(i = 1; i < option_tmp->nb_arg  + 1; i++)
            {

                NEW(arg, option_tmp->fa, arg_tmp);

                arg_tmp->id = tab[2*(i-1) + 1];
                if(tab[2*(option_tmp->nb_arg-i)  + 2]>0)
                {
		    sent++;
                    copy_str(glb_fd, tab[2*(option_tmp->nb_arg-i)  + 2], glb_out, " ");
		}
                if(arg_tmp->id < 0)
                {
                    arg_tmp->type = GAA_LIST;
                    arg_tmp->id *= -1;
                }
                else
                {
                    arg_tmp->type = GAA_SINGLE;
                }
            }
            if (sent==0) fputs( "\"\"", glb_out);
	    fprintf(glb_out, ", ");
            copy_str(glb_fd, yyvsp[0], glb_out, NULL);
            fprintf(glb_out,");\n");
        }
    break;
case 23:
#line 540 "gaa_parser.y"
{
            int i, *tab, sent=0;
            SUPERLOOKUP(id2, yyvsp[-4], yylsp[-8].first_line);
            SUPERLOOKUP(id1, yyvsp[-6], yylsp[-8].first_line);

            if(strlen(num2str(yyvsp[-6])) != 1)
            {
                fprintf( stderr, "%s:%d: first identifier must be a single character\n", st_in, yylsp[-8].first_line);
                error_flag = 1;
            }
            NEW(option, first_option, option_tmp);
            option_tmp->fa = NULL;
            option_tmp->id1 = yyvsp[-6];
            option_tmp->id2 = yyvsp[-4];
            option_tmp->action = yyvsp[-1];
            option_tmp->line = yylsp[-8].first_line;
            option_tmp->help = yyvsp[0];
            tab = (int*)yyvsp[-2];
            option_tmp->nb_arg = tab[0];
            nb_option++;
	    fprintf(glb_out, "\t__gaa_helpsingle('%c', \"%s\", ",
		num2str(yyvsp[-6])[0], num2str(yyvsp[-4]));
            for(i = 1; i < option_tmp->nb_arg  + 1; i++)
            {
		
                NEW(arg, option_tmp->fa, arg_tmp);

                arg_tmp->id = tab[2*(i-1) + 1];
                if(tab[2*(option_tmp->nb_arg-i)  + 2]>0)
                {
		    sent++;
                    copy_str(glb_fd, tab[2*(option_tmp->nb_arg-i)  + 2], glb_out, " ");
                }
                if(arg_tmp->id < 0)
                {
                    arg_tmp->type = GAA_LIST;
                    arg_tmp->id *= -1;
                }
                else
                {
                    arg_tmp->type = GAA_SINGLE;
                }
            }
            if (sent==0) fputs( "\"\"", glb_out);
            fprintf(glb_out, ", ");
            copy_str(glb_fd, yyvsp[0], glb_out, NULL);
            fprintf(glb_out,");\n");
        }
    break;
case 24:
#line 589 "gaa_parser.y"
{
            int i, *tab;
            
            rest_action = yyvsp[0];
            tab = (int*)yyvsp[-1];
            rest_nb_arg = tab[0];
            
            for(i = 1; i < rest_nb_arg  + 1; i++)
            {
                NEW(arg, first_rest_arg, arg_tmp);

                arg_tmp->id = tab[2*(i-1) + 1];
                if(arg_tmp->id < 0)
                {
                    arg_tmp->type = GAA_LIST;
                    arg_tmp->id *= -1;
                }
                else
                {
                    arg_tmp->type = GAA_SINGLE;
                }
            }
        }
    break;
case 25:
#line 613 "gaa_parser.y"
{
            NEW(condition, first_condition, condition_tmp);
            condition_tmp->options = yyvsp[0];
            condition_tmp->type = GAA_OBLIGAT;
	    k_needed = 1;
        }
    break;
case 26:
#line 620 "gaa_parser.y"
{
            NEW(condition, first_condition, condition_tmp);
            condition_tmp->options = yyvsp[0];
            condition_tmp->type = GAA_INCOMP;
	    k_needed = 1;
        }
    break;
case 27:
#line 627 "gaa_parser.y"
{
	    glb_underscore_strings = 1;
        }
    break;
}

#line 727 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 632 "gaa_parser.y"


extern int loc_index;

struct _idStruct;
typedef struct _idStruct idStruct;

struct _idStruct
{
    char *name;
    int line; /* the first line it was encountered */
    idStruct *next;
};

idStruct *firstId = NULL;

#define RM(x) remove_illegal_C_char(x)
static char *remove_illegal_C_char( const char* str)
{
static char ret[512];
int i;
	if (strlen(str)+1 > sizeof(ret)) {
		fprintf(stderr, "num2str: Too long string\n");
		exit(1);
	}
	memset( ret, 0, sizeof ret);
	for (i=0;i<strlen(str);i++) {
		ret[i] = str[i];
		if (ret[i]=='-') ret[i]='_';
	}
	ret[i]=0;

	return ret;
}

char* num2str(int n)
{
    int i;
    idStruct *tmp;
    tmp = firstId;
    if(n == 0)
	return "";
    for(i = 0; (i < n - 1) && (tmp != NULL); i++)
    {
        tmp = tmp->next;
    }
    if(tmp == NULL)
    {
        fprintf(stderr, "num2str: Out of range\n");
        exit(1);
    }
    return tmp->name;
}

/* returns the line of the identifier, indexed
 * by n;
 */
int get_id_line(int n)
{
    int i;
    idStruct *tmp;
    tmp = firstId;
    if(n == 0)
	return num_lines - 1;
    for(i = 0; (i < n - 1) && (tmp != NULL); i++)
    {
        tmp = tmp->next;
    }
    if(tmp == NULL)
    {
        fprintf(stderr, "get_id_line: Out of range\n");
        exit(1);
    }
    return tmp->line;
}

int length(char *a)
{
    int i = 0;
    while(*(a+i) != 0) i++;
    return i;
}

int getTokenNum( char* str) {
int i;
     for (i = 0; i < YYNTOKENS; i++)
     {
     	   if (yytname[i] != 0
		&& yytname[i][0] == '"'
    	        && strncasecmp (yytname[i] + 1, str, strlen (str)) == 0
 	        && yytname[i][strlen (str) + 1] == '"'
                && yytname[i][strlen (str) + 2] == 0)
	   {
	       return yytoknum[i];
	   }
     }
     return -1;
}

int getIdNum(char *name, int line)
{
    int len, data = 1;
    idStruct **pter, *blurp;
    
    pter = &firstId;
    while(*pter != NULL)
    {
        if(strcmp(name, (*pter)->name) == 0)
            break;
        data++;
        pter = &((*pter)->next);
    }
    if(*pter == NULL)
    {
        blurp = *pter;
        len = length(name);
        blurp = malloc(sizeof(idStruct));
        *pter = blurp;
        blurp->name = malloc((len + 1)* sizeof(char));
        strcpy(blurp->name, name);
        blurp->next = NULL;
        blurp->line = line;
    }

    return data;
}

#define MAXIDSIZE 300

char *tmpStr;


int yyerror( char* s)  /* Called by yyparse on error */
{
    fprintf (stderr, "%s:%d: %s\n", st_in, num_lines, s);
    exit(1);
}

/* Copies the skel file to target file
 * if term!=EOF, then the file is copied until
 * the terminator byte.
 * 
 * This function will use the file seek pointers
 * to keep a state in copying.
 */
void copy_file_state(FILE* source, FILE* target, int term)
{
    int a;
    do
    {
        if( (a=fgetc(source)) == EOF && term!=EOF)
        {
            fprintf(stderr, "copy_file_state: Source read error\n");
            exit(1);
        }
        if(a != term)
        {
            if(fputc(a, target) == EOF)
            {
                fprintf(stderr, "copy_file_state: Output write error\n");
                exit(1);
            }
        }
    }
    while(a != term);
}

/* Returns the number of the line, that the index-th character
 * is placed.
 */
int getline(FILE* fd, int index)
{
    int tmp, line = 1, i;
    int a = 0;
    tmp = fseek(fd, 0, SEEK_CUR);
    fseek(fd, 0, SEEK_SET);
    for(i = 0; i < index; i++)
    {
        a=fgetc(fd);
        if(a==EOF) {
            printf("Read error\n");
            exit(1);
	}
        if(a == '\n')
            line++;
    }
    fseek(fd, tmp, SEEK_SET);
    return line;
}

/* term holds the terminator character ';', or '\n'
 */
void copy_line(FILE* fd, int index, FILE* target, char* file, char term)
{
    int a;
    fprintf(target, "#line %d \"%s\"\n\t", getline(fd, index), file);
    fseek(fd, index, SEEK_SET);
    do
    {
        if( (a=fgetc(fd)) == EOF)
        {
            printf("Read error\n");
            exit(1);
        }
        if(fputc(a, target) == EOF)
        {
            printf("Output write error\n");
            exit(1);
        }
    }
    while(a != term);
}

void put_action( FILE* fd, int index, FILE* target, char *opt, int narg, char* file)
{
    int a;
    char *str_cmp;
    int i, flag = 1;
    fprintf(target, "#line %d \"%s\"\n", getline(fd, index), file);
    fprintf(target, "{");
    fseek(fd, index, SEEK_SET);
    if(opt[0] == 0)
        str_cmp = "GAAREST_tmp";
    else
        str_cmp = "GAATMP_";
    while(flag != 0)
    {
        if( (a=fgetc(fd)) == EOF)
        {
            printf("Read error\n");
            exit(1);
        }
        switch(a)
            {
            case '{':
                flag ++;
                break;
            case '}':
                flag --;
                break;
            case '@':
                i = 0;
                a = '0';
                flag *= -1;
                do
                {
                    i *= 10;
                    i += (a - '0');
                    if( (a=fgetc(fd)) == EOF)
                    {
                        printf("Read error\n");
                        exit(1);
                    }
                }
                while(isdigit(a) != 0);
                fseek(fd, -1, SEEK_CUR);
                if(( i > narg ) || (i <= 0))
                {
                    printf("Fatal: Option %s: argument $%d unknown\n", opt, i);
                    exit(1);
                }
                fprintf(target, "%s%s.size%d", str_cmp, RM(opt), i);
                break;
            case '$':
                if( (a=fgetc(fd)) == EOF)
                {
                    printf("Read error\n");
                    exit(1);
                }
                fseek(fd, -1, SEEK_CUR);
                flag *= -1;
                if(isdigit(a) == 0)
                {
                    fprintf(target, "gaaval->");
                }
                else
                {
                    i = 0;
                    a = '0';
                    do
                    {
                        i *= 10;
                        i += (a - '0');
                        if( (a=fgetc(fd)) == EOF)
                        {
                            printf("Read error\n");
                            exit(1);
                        }
                    }
                    while(isdigit(a) != 0);
                    fseek(fd, -1, SEEK_CUR);
                    if(( i > narg ) || (i <= 0))
                    {
                        printf("Fatal: Option %s: argument $%d unknown\n", opt, i);
                        exit(1);
                    }
                    fprintf(target, "%s%s.arg%d", str_cmp, RM(opt), i);
                }
                break;
            default:  break;
            }
        if(flag > 0)
        {
            if(fputc( a, target) == EOF)
            {
                printf("Output write error\n");
                exit(1);
            }
        }
        if(flag < 0)
            flag *= -1;
    }
    fprintf(target, ";};\n");
}

/* copies the file until it finds #} */
void copy_file(FILE* fd, int index, FILE* target, char *file)
{
    int a, pa = -1;
    fprintf(target, "#line %d \"%s\"\n", getline(fd, index), file);
    fseek(fd, index, SEEK_SET);
    while( (a=fgetc(fd)) != EOF)
    {
        if (pa=='#' && a=='}') break;

	if (pa!=-1)
		if(fputc( pa, target) == EOF)
	        {
	            printf("Output write error\n");
	            exit(1);
	       	}
	pa = a;
    };

    if (a==EOF) {
	    if(fputc( pa, target) == EOF)
	    {
	            printf("Output write error\n");
	            exit(1);
	    }
    }
}

void add_type(char *id, char *fnName, char *type)
{
    NEW(atype, first_atype, atype_tmp);
    atype_tmp->id = getIdNum(id, 0);
    atype_tmp->fnName = getIdNum(fnName, 0);
    atype_tmp->type_str = type;
    nb_atype++;
}

#define SHORTNAME num2str(option_tmp_loc->id1)
#define LONGNAME num2str(option_tmp_loc->id2)

char __optional_flag;

void write_get_arg(FILE *out, arg *x, char *name, int arg_number)
{
    char *str_name;
    char _name[512];

    strcpy( _name, RM(name));

    if(x->id == 0)
	{
	__optional_flag = 1;
	return;
	}
    
    if(name[0] == 0)
        str_name = "GAAREST_tmp";
    else
        str_name = "GAATMP_";

    if(x->type == GAA_SINGLE)
     {
	if(__optional_flag)
	{
        fprintf(out, "\t\tGAA_TESTMOREOPTIONALARGS;\n\t\tGAA_FILL(%s%s.arg%d, %s, %s%s.size%d);\n\t\tgaa_index++;\n",
                str_name,_name,arg_number,RM(num2str(get_type(x)->fnName)),str_name,_name,arg_number);
	}
	else
        {
        fprintf(out, "\t\tGAA_TESTMOREARGS;\n\t\tGAA_FILL(%s%s.arg%d, %s, %s%s.size%d);\n\t\tgaa_index++;\n",
                str_name,_name,arg_number,RM(num2str(get_type(x)->fnName)),str_name, _name,arg_number);
        }
     }
    else
     {
        if(!__optional_flag)
        fprintf(out, "\t\tGAA_LIST_FILL(%s%s.arg%d, %s, %s, %s%s.size%d);\n",
                str_name,_name,arg_number,
                RM(num2str(get_type(x)->fnName)), get_type(x)->type_str,
                str_name,_name,arg_number);
	else
        fprintf(out, "\t\tGAA_OPTIONALLIST_FILL(%s%s.arg%d, %s, %s, %s%s.size%d);\n",
                str_name,_name,arg_number,
                RM(num2str(get_type(x)->fnName)), get_type(x)->type_str,
                str_name,_name,arg_number);
     }
}

#define EXT_GAA_H "_gaa.h"
#define EXT_GAA_C "_gaa.c"

int main(int argc, char **argv)
{
    option *option_tmp_loc;
    atype *atype_tmp_loc;
    struct_elt *struct_elt_tmp_loc;
/*    help *help_tmp_loc;   */
    arg *arg_tmp_loc;
    FILE* fd,* skel;
    FILE *out,*header;
    int i, j, k, header_start, header_limit;
    int rval;
    int a;
    char *st_out,*st_header, *ptr;
    gaainfo info;

    if(gaa(argc, argv, &info) != -1)
    {
        return 0;
    }
    if(info.skel == NULL)
      {
       j = 0;
       info.skel = malloc(sizeof(char) * (length("gaa.skel") + length(argv[0])));
       for(i = 0; i < length(argv[0]); i++)
	  {
	    if(argv[0][i] == '\\')
		j = i+1;
            info.skel[i] = argv[0][i];
	  }
       strcpy(info.skel + j, "gaa.skel");
      }
    st_in = info.input; st_out = info.output; st_header = info.header;

    /* generate file names
     */
    if (st_header==NULL) {
	st_header= malloc( strlen(st_in)+ strlen(EXT_GAA_H));
        strcpy(st_header, st_in);
	ptr = strstr( st_header, ".gaa");
	if (ptr==NULL)
		strcat( st_header, EXT_GAA_H);
	else
		strcpy( ptr, EXT_GAA_H);
    }
    if (st_out==NULL) {
	st_out= malloc( strlen(st_in)+ strlen(EXT_GAA_C));
        strcpy(st_out, st_in);
	ptr = strstr( st_out, ".gaa");
	if (ptr==NULL) 
		strcat( st_out, EXT_GAA_C);
	else
		strcpy( ptr, EXT_GAA_C);
    }

    if((skel = fopen(info.skel, "r")) == NULL)
    {
        printf("Could'nt open skeleton file: %s\n", info.skel);
        exit(1);
    }
    if((glb_fd = fopen(st_in, "r")) == NULL)
    {
        printf("Could'nt open gaa file '%s'.\n", st_in);
        exit(1);
    }
    if((out = fopen(st_out, "w+")) == NULL)
    {
        printf("Could'nt open output file '%s'.\n", st_out);
        exit(1);
    }
    if((glb_out = tmpfile()) == NULL)
    {
        printf("Could'nt open tmp output file.\n");
        exit(1);
    }
    glb_skel = skel;
    tmpStr = malloc((MAXIDSIZE + 1)*sizeof(char));

    if(( glb_sfd=fopen(st_in, "r")) == NULL)
    {
        printf("Could'nt open gaa file\n");
        exit(1);
    }

    fprintf(out, "/* File generated by GAA %s\n */\n", VERSION);

    /* write the WIN32 headers */
    if(info.win32 == 1)
      fprintf(out, "#define GAA_WIN32\n");
    else  
      fprintf(out, "#define GAA_NO_WIN32\n");

    /* Parse the input file */
    rval = yyparse();
    fclose( glb_sfd);
    free(tmpStr);

    fd = glb_fd;

    /* Write the C declarations */
    if(c_code != -1)
        copy_file(fd, c_code, out, st_in);

    /* Write the skel file */
    copy_file_state(skel,out, '@');

    fseek( glb_out, 0, SEEK_SET);
    copy_file_state(glb_out, out, EOF);
    fclose(glb_out); /* close tmp file */

    copy_file_state(skel,out, '@');

    header_start = ftell(out);
    if((rval != 0) || (error_flag == 1))
        return 1;
    
    for(i = 0; i < nb_atype; i++)
    {
        atype_tmp_loc = get_atype(i);
        read_str(fd, atype_tmp_loc->argtype, &(atype_tmp_loc->type_str), ';');
    }
    add_type("STR", "gaa_getstr", "char*");
    add_type("INT", "gaa_getint", "int");
    add_type("CHAR", "gaa_getchar", "char");
    add_type("FLOAT", "gaa_getfloat", "float");
    
    copy_file_state(skel,out, '@');
    for(i = 0; i < nb_struct_elt; i++)
    {
        struct_elt_tmp_loc = get_struct_elt(i);
        if(struct_elt_tmp_loc->data == 0)
            copy_line(fd, struct_elt_tmp_loc->location, out, st_in, ';');
        else
        {
            if(struct_elt_tmp_loc->type == GAA_SINGLE)
            fprintf(out, "\t%s %s;",
                    get_atype_from_id(struct_elt_tmp_loc->arg_type)->type_str,
                    num2str(struct_elt_tmp_loc->id));
            else
            fprintf(out, "\t%s *%s;",
                    get_atype_from_id(struct_elt_tmp_loc->arg_type)->type_str,
                    num2str(struct_elt_tmp_loc->id));
        }
        fprintf(out, "\n");
    }
    copy_file_state(skel,out, '@');
    header_limit = ftell(out);
    copy_file_state(skel,out, '@');

    fprintf(out, "%d\n", nb_option + nb_option_argless);

    for(j = 0; j < nb_option; j++)
    {
        option_tmp_loc = get_option(j);

        fprintf(out,"#define GAAOPTID_%s\t%d\n", RM(num2str( option_tmp_loc->id2)),
	 j + 1 );
    }

    copy_file_state(skel,out, '@');
    for(i = 0; i < nb_option; i++)
    {
	k = 0;
        option_tmp_loc = get_option(i);
        if(option_tmp_loc->nb_arg > 0)
        {
         fprintf(out, "\nstruct GAAOPTION_%s \n{\n", RM(num2str(option_tmp_loc->id2)));
         for(j = 0; j < option_tmp_loc->nb_arg; j++)
         {
             arg_tmp_loc = get_arg(i,j);
	    if(arg_tmp_loc->id != 0)
	    {
	     k++;
             atype_tmp_loc = get_type(arg_tmp_loc);
             fprintf(out, "\t%s", atype_tmp_loc->type_str);
             if(arg_tmp_loc->type == GAA_LIST)
                 fprintf(out, "*");
             fprintf(out, " arg%d;\n", k);
/*             if(arg_tmp_loc->type == GAA_LIST) */
                 fprintf(out, "\tint size%d;\n", k);
	   }
         }
        fprintf(out, "};\n");
       }
    }
    if(rest_nb_arg != 0)
    {
        fprintf(out, "#define GAA_REST_EXISTS\n");
        fprintf(out, "\nstruct GAAREST\n{\n");
	j = 0;
        for(arg_tmp_loc = first_rest_arg; arg_tmp_loc != NULL; arg_tmp_loc = arg_tmp_loc->next)
        {

	    if(arg_tmp_loc->id != 0)
	    {
            atype_tmp_loc = get_type(arg_tmp_loc);
            fprintf(out, "\t%s", atype_tmp_loc->type_str);
            if(arg_tmp_loc->type == GAA_LIST)
                fprintf(out, "*");
            fprintf(out, " arg%d;\n", j + 1);
/*            if(arg_tmp_loc->type == GAA_LIST)*/
                fprintf(out, "\tint size%d;\n", j+1);
	    j++;
	    }
        }
        fprintf(out, "};\n");
    }
    copy_file_state(skel,out, '@');
    for(j = 0; j < nb_option; j++)
    {
        option_tmp_loc = get_option(j);
        if(option_tmp_loc->nb_arg != 0)
        fprintf(out,"\t\t\tGAA_CHECK1STR(\"%s\", GAAOPTID_%s);\n",
		num2str(option_tmp_loc->id1), RM(num2str(option_tmp_loc->id2)));
    }
    copy_file_state(skel,out,'@');
    for(j = 0; j < nb_option; j++)
    {
        option_tmp_loc = get_option(j);
        if(option_tmp_loc->nb_arg == 0)
        fprintf(out,"\t\t\tGAA_CHECK1STR(\"%s\", GAAOPTID_%s);\n",
		num2str(option_tmp_loc->id1), RM(num2str(option_tmp_loc->id2)));
    }
    copy_file_state(skel,out, '@');
    for(j = 0; j < nb_option; j++)
    {
        option_tmp_loc = get_option(j);
        fprintf(out,"\t\t\tGAA_CHECKSTR(\"%s\", GAAOPTID_%s);\n",
		num2str(option_tmp_loc->id2), RM(num2str(option_tmp_loc->id2)));
    }
    copy_file_state(skel,out, '@');
    
    for(j = 0; j < nb_option; j++)
    {
        option_tmp_loc = get_option(j);
	if(option_tmp_loc->nb_arg > 0)
        fprintf(out,"\tstruct GAAOPTION_%s GAATMP_%s;\n",
		RM(num2str(option_tmp_loc->id2)), RM(num2str(option_tmp_loc->id2)));
    }
    copy_file_state(skel,out, '@');
/*    for(j = 0; j < nb_option_argless; j++)
    {
        option_argless_tmp_loc = get_option_argless(j);
        fprintf(out,"\tcase GAAOPTID_%s:\n", RM(ALONGNAME));
        put_action(fd, option_argless_tmp_loc->action, out, ALONGNAME, 0, st_in);
        fprintf(out,"\n\t\treturn GAA_OK;\n\t\tbreak;\n");
    }     */
    for(i = 0; i < nb_option; i++)
    {
        __optional_flag = 0;
        option_tmp_loc = get_option(i);
        fprintf(out,"\tcase GAAOPTID_%s:\n\tOK = 0;\n", RM(LONGNAME));
	k = 0;
        for(j = 0; j < option_tmp_loc->nb_arg; j++)
        {
            arg_tmp_loc = get_arg(i,j);
	    if(arg_tmp_loc->id != 0)
		k ++;
            write_get_arg(out, arg_tmp_loc, LONGNAME, k);
        }
        put_action(fd, option_tmp_loc->action, out, LONGNAME, option_tmp_loc->nb_arg, st_in);
        fprintf(out,"\n\t\treturn GAA_OK;\n\t\tbreak;\n");
    }
    if(rest_nb_arg != 0)
    {
        j = 1;
        fprintf(out,"\tcase GAA_REST:\n");
        for(arg_tmp_loc = first_rest_arg; arg_tmp_loc != NULL; arg_tmp_loc = arg_tmp_loc->next)
        {
            write_get_arg(out, arg_tmp_loc, "", j);
            if(arg_tmp_loc->id != 0)
              j++;
        }
        put_action(fd, rest_action, out, "", rest_nb_arg, st_in);
        fprintf(out,"\n\t\treturn GAA_OK;\n\t\tbreak;\n");
    }
    copy_file_state(skel,out, '@');
    if(k_needed)
        fprintf(out, ", k");
    copy_file_state(skel, out, '@');
    if(init_loc >= 0)
        put_action(fd, init_loc, out, "init", 0, st_in);
    copy_file_state(skel,out, '@');
    for(condition_tmp = first_condition; condition_tmp != NULL;
        condition_tmp = condition_tmp->next)
    {
        switch(condition_tmp->type)
            {
            case GAA_OBLIGAT:
                fprintf(out, "\tGAA_OBLIGAT(\"%s\");\n", num2str(condition_tmp->options));
                break;
            case GAA_INCOMP:
                fprintf(out, "\tGAA_INCOMP(\"%s\");\n", num2str(condition_tmp->options));
                break;
            default:  break;
            }
    }
    copy_file_state(skel,out, '@');
    
    
    if((header = fopen(st_header, "w")) == NULL)
    {
        printf("Could'nt open header file '%s'.\n", st_header);
        exit(1);
    }

    fseek(out, header_start, SEEK_SET);
    for(i = header_start; i < header_limit; i++)
    {
        if( (a=fgetc(out)) == EOF)
        {
            printf("Read error\n");
            exit(1);
        }
        if(fputc( a, header) == EOF)
        {
            printf("Header write error\n");
            exit(1);
        }
    }
        
    return 0;
}

void gaa_version(void) {
	printf("Reading skeleton from %s\n", SKEL_DIR);
	printf("gaa version %s\n", VERSION);
}
