/* db.c - functions to handle a linked list of records
   Copyright (C) 1999 Matt Fisher (mfisher1@bigred.unl.edu)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "db.h"

/* Definition of a record in linked list
 */
struct corydb *init_list( void )
    {
    struct corydb *tmp;
    tmp = (struct corydb *)malloc( sizeof( struct corydb ) );
    tmp->next = 0;
    strcpy( tmp->index_text, "" );
    return tmp;
    }

/* Add record to list

   Input:	struct corydb *cur_list, char *index_text, char *info_text
   Output:	null
 */
void add_list( struct corydb *cur_list, char *index_text, char *info_text )
    {
    struct corydb *curptr, *tmpptr, *newptr;
    curptr = cur_list;
    while( (curptr->next != 0) && (strcmp( curptr->index_text, index_text ) > 0) )
        curptr = curptr->next;
    if( strcmp( curptr->index_text, index_text ) == 0 )
        {
        edit_list( cur_list, index_text, info_text );
        return;
        }
    tmpptr = curptr->next;
    newptr = malloc( sizeof( struct corydb ) );
    if( newptr == NULL )
        return;
    newptr->next = tmpptr;
    curptr->next = newptr;
    strcpy( newptr->index_text, index_text );
    newptr->info_text = malloc( strlen( info_text ) + 1 );
    if( newptr->info_text == NULL )
        {
        free( newptr );
        return;
        }
    strcpy( newptr->info_text, info_text );
    }

/* Remove record from list

   Input:	struct corydb *cur_list, char *index_text
   Output:	null
 */
void del_list( struct corydb *cur_list, char *index_text )
    {
    struct corydb *curptr, *tmpptr;
    curptr = cur_list;
    while( (curptr->next != 0) && (strcmp( curptr->next->index_text, index_text ) != 0) )
        curptr = curptr->next;
    if( curptr->next == 0 )
        return;
    tmpptr = curptr->next->next;
    free( curptr->next->info_text );
    free( curptr->next );
    curptr->next = tmpptr;
    }

/* Replace a record in list

   Input:	struct corydb *cur_list, char *index_text, char *new_text
   Output:	null
*/
void edit_list( struct corydb *cur_list, char *index_text, char *new_text )
    {
    del_list( cur_list, index_text );
    add_list( cur_list, index_text, new_text );
    }

/* Read a record from list

   Input:	struct corydb *cur_list, char *index_text
   Output:	null
 */
char *retr_list( struct corydb *cur_list, char *index_text )
    {
    struct corydb *curptr;
    curptr = cur_list;
    while( (curptr->next != 0) && (strcmp( curptr->index_text, index_text ) != 0) )
        curptr = curptr->next;
    return curptr->info_text;
    }


void wipe_list( struct corydb *cur_list )
{
  struct corydb *curptr, *tmpptr;
  curptr = cur_list;
  while( curptr->next != 0 )
    {
      tmpptr = curptr;
      curptr = curptr->next;
      free( tmpptr );
    }
}
