#
# $Id: ganglia.spec.in,v 1.37 2006/03/27 22:52:30 bernardli Exp $
#
# ganglia.spec.  Generated from ganglia.spec.in by configure.
#
# IMPORTANT NOTE:
# This spec file has a noarch section.  RPM is braindead in that it cannot
# build mixed architecture packages.  As a workaround, you must build
# the RPMs using the following commandline
#
# % rpmbuild -ta --target noarch,i386 ganglia-3.0.3.tar.gz
#
Summary: Ganglia Distributed Monitoring System
Name: ganglia
Version: 3.0.3
URL: http://ganglia.info/
Release: 1 
License: BSD
Vendor: Ganglia Development Team <ganglia-developers@lists.sourceforge.net>
Group: System Environment/Base
Source: %{name}-%{version}.tar.gz
Buildroot: /tmp/%{name}-%{version}-buildroot
Prefix: /usr

%description
Ganglia is a scalable, real-time monitoring and execution environment

######################################################################
################## noarch section ####################################
######################################################################
%ifarch noarch
%package web
Summary: Ganglia Web Frontend
Group: System Environment/Base
Obsoletes: ganglia-webfrontend
Provides: ganglia-webfrontend
# We should put rrdtool as a Requires too but rrdtool rpm support is very weak
# so most people install from source
#Requires: ganglia-gmetad >=  3.0.3
%define web_prefixdir /var/www/html/ganglia
Prefix: %{web_prefixdir}

%description web
This package provides a web frontend to display the XML tree published by
ganglia, and to provide historical graphs of collected metrics. This website is
written in the PHP4 language.

#######################################################################
#######################################################################
%else

%package gmetad
Summary: Ganglia Meta daemon http://ganglia.sourceforge.net/
Group: System Environment/Base
Obsoletes: ganglia-monitor-core-gmetad ganglia-monitor-core

%description gmetad
Ganglia is a scalable, real-time monitoring and execution environment
with all execution requests and statistics expressed in an open
well-defined XML format.

This gmetad daemon aggregates monitoring data from several clusters
to form a monitoring grid. It also keeps metric history using rrdtool.

%package gmond
Summary: Ganglia Monitor daemon http://ganglia.sourceforge.net/
Group: System Environment/Base
Obsoletes: ganglia-monitor-core-gmond ganglia-monitor-core

%description gmond
Ganglia is a scalable, real-time monitoring and execution environment
with all execution requests and statistics expressed in an open
well-defined XML format.

This gmond daemon provides the ganglia service within a single cluster or
Multicast domain.

%package devel
Summary: Ganglia Library http://ganglia.sourceforge.net/
Group: System Environment/Base
Obsoletes: ganglia-monitor-core-lib 

%description devel
The Ganglia Monitoring Core library provides a set of functions that programmers
can use to build scalable cluster or grid applications

%endif

##
## PREP
##

%prep 
%setup

##
## BUILD
##
%build
./configure --prefix=/usr --with-gmetad
make

##
## PRE
##
%pre

%ifnarch noarch
##
## POST GMETA
##
%post gmetad
/sbin/chkconfig --add gmetad

if [ "$1" == "1" ]; then
   # Installing new package - start gmetad
   /etc/rc.d/init.d/gmetad start
elif [ "$1" -gt "1" ]; then
   # Upgrading ganglia package - restart gmetad
   /etc/rc.d/init.d/gmetad restart
fi


##
## POST GMON
##
%post gmond
/sbin/chkconfig --add gmond

if [ "$1" == "1" ]; then
   # Installing new package - start gmond
   /etc/rc.d/init.d/gmond start
elif [ "$1" -gt "1" ]; then
   # Upgrading ganglia package - restart gmond
   /etc/rc.d/init.d/gmond restart
fi

`rpm -q ganglia-monitor-core-gmond| grep "is not installed" > /dev/null 2>&1`
if [[ $? != 0 ]]; then
  # They have an old configuration file format
  echo "-----------------------------------------------------------"
  echo "IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT IMPORTANT"
  echo "-----------------------------------------------------------"
  echo "It appears that you are upgrading from ganglia gmond version"
  echo "2.5.x.  The configuration file has changed and you need to "
  echo "convert your old 2.5.x configuration file to the new format."
  echo ""   
  echo "To convert your old configuration file to the new format"
  echo "simply run the command:"
  echo ""
  echo "% gmond --convert old.conf > new.conf"
  echo ""
  echo "This conversion was not made automatic to prevent unknowningly"
  echo "altering your configuration without your notice."
fi
   

##
## PREUN GMETA
##
%preun gmetad
if [ "$1" = 0 ]
then
   /etc/rc.d/init.d/gmetad stop
   /sbin/chkconfig --del gmetad
fi

##
## PREUN GMON
##
%preun gmond
if [ "$1" = 0 ]
then
   /etc/rc.d/init.d/gmond stop
   /sbin/chkconfig --del gmond
fi

#ifnarch noarch
%endif

##
## INSTALL
##
%install
## Flush any old RPM build root
%__rm -rf $RPM_BUILD_ROOT

%ifarch noarch

%__mkdir -p $RPM_BUILD_ROOT/%{web_prefixdir}
%__cp -rf %{_builddir}/%{name}-%{version}/web/* $RPM_BUILD_ROOT/%{web_prefixdir}

%else

## Create the directory structure
%__mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
%__mkdir -p $RPM_BUILD_ROOT/var/lib/ganglia/rrds
%__mkdir -p $RPM_BUILD_ROOT/usr/share/man/man5

## Move the files into the structure
if [ -f /etc/SuSE-release ]; then
   %__cp -f %{_builddir}/%{name}-%{version}/gmond/gmond.init.SuSE $RPM_BUILD_ROOT/etc/rc.d/init.d/gmond
   %__cp -f %{_builddir}/%{name}-%{version}/gmetad/gmetad.init.SuSE $RPM_BUILD_ROOT/etc/rc.d/init.d/gmetad
   chmod +x $RPM_BUILD_ROOT/etc/rc.d/init.d/gmond
   chmod +x $RPM_BUILD_ROOT/etc/rc.d/init.d/gmetad
else
   %__cp -f %{_builddir}/%{name}-%{version}/gmond/gmond.init $RPM_BUILD_ROOT/etc/rc.d/init.d/gmond
   %__cp -f %{_builddir}/%{name}-%{version}/gmetad/gmetad.init $RPM_BUILD_ROOT/etc/rc.d/init.d/gmetad
fi

# We just output the default gmond.conf from gmond using the '-t' flag
%{_builddir}/%{name}-%{version}/gmond/gmond -t > $RPM_BUILD_ROOT/etc/gmond.conf
%__cp -f %{_builddir}/%{name}-%{version}/gmetad/gmetad.conf $RPM_BUILD_ROOT/etc/gmetad.conf

%__make install prefix=$RPM_BUILD_ROOT/usr
%__cp -f %{_builddir}/%{name}-%{version}/gmond/gmond.conf.5 $RPM_BUILD_ROOT/usr/share/man/man5/gmond.conf.5

%endif

%ifnarch noarch
##
## FILES GMETA
##

%files gmetad
%defattr(-,root,root)
%attr(0755,nobody,nobody)/var/lib/ganglia/rrds
/usr/sbin/gmetad
/etc/rc.d/init.d/gmetad
%config(noreplace) /etc/gmetad.conf

##
## FILES GMON
##
%files gmond
%defattr(-,root,root)
%attr(0500,root,root)/usr/bin/gmetric
%attr(0555,root,root)/usr/bin/gstat
/usr/sbin/gmond
/etc/rc.d/init.d/gmond
%attr(0555,root,root)/usr/share/man/man5/gmond.conf.5*
%config(noreplace) /etc/gmond.conf

##
## FILES DEVEL
##
%files devel
/usr/include/ganglia.h
/usr/lib/libganglia*
/usr/bin/ganglia-config

%else

##
## FILES WEB
##
%files web
%defattr(-,root,root)
%config(noreplace) %{web_prefixdir}/conf.php
%{web_prefixdir}

%endif

##
## CLEAN
##
%clean
%__rm -rf $RPM_BUILD_ROOT

##
## CHANGELOG
##
%changelog
* Fri Feb 25 2006 Bernard Li <bli@bcgsc.ca>
- Use SuSE specific init scripts if /etc/SuSE-release file exists
* Fri Dec 10 2004 Matt Massie <massie@cs.berkeley.edu>
- Updated the spec file for 2.6.0 release
* Tue Apr 13 2004 Brooks Davis <brooks@one-eyed-alien.net>
- Use the autoconf variable varstatedir instead of /var/lib for consistancy.
* Thu Feb 19 2004 Matt Massie <massie@cs.berkeley.edu>
- Removed the /usr/include/ganglia directory from the lib rpm and
  changed the deprecated Copyright to License
* Mon Oct 14 2002 Federico Sacerdoti <fds@sdsc.edu>
- Split package into -gmetad and -gmond subpackages for clarity,
  and separation of purpose/functionality.
* Thu Sep 19 2002 Federico Sacerdoti <fds@sdsc.edu>
- Added config files, made /var/lib/ganglia for RRD storage.
* Mon Mar 11 2002 Matt Massie <massie@cs.berkeley.edu>
- Added support for libganglia, added Prefix: for RPM relocation
* Wed Feb 27 2002 Matt Massie <massie@cs.berkeley.edu>
- Merge gmetric and gmond together into one RPM.  Fix some small bugs.
* Fri Nov  2 2001 Matt Massie <massie@cs.berkeley.edu>
- initial release
