/*
  File autogenerated by gengetopt version 2.11
  generated with the following command:
  /usr/bin/gengetopt --input ./cmdline.sh 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  The Ganglia Metric Client (gmetric) announces a metric\n"
  "  on the list of defined send channels defined in a configuration file\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help          Print help and exit\n");
  printf("  -V, --version       Print version and exit\n");
  printf("  -c, --conf=STRING   The configuration file to use for finding send channels  \n                        (default=`/etc/gmond.conf')\n");
  printf("  -n, --name=STRING   Name of the metric\n");
  printf("  -v, --value=STRING  Value of the metric\n");
  printf("  -t, --type=STRING   Either \n                        string|int8|uint8|int16|uint16|int32|uint32|float|double\n");
  printf("  -u, --units=STRING  Unit of measure for the value e.g. Kilobytes, Celcius  \n                        (default=`')\n");
  printf("  -s, --slope=STRING  Either zero|positive|negative|both  (default=`both')\n");
  printf("  -x, --tmax=INT      The maximum time in seconds between gmetric calls  \n                        (default=`60')\n");
  printf("  -d, --dmax=INT      The lifetime in seconds of this metric  (default=`0')\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->name_given = 0 ;
  args_info->value_given = 0 ;
  args_info->type_given = 0 ;
  args_info->units_given = 0 ;
  args_info->slope_given = 0 ;
  args_info->tmax_given = 0 ;
  args_info->dmax_given = 0 ;
#define clear_args() { \
  args_info->conf_arg = gengetopt_strdup("/etc/gmond.conf") ;\
  args_info->name_arg = NULL; \
  args_info->value_arg = NULL; \
  args_info->type_arg = NULL; \
  args_info->units_arg = gengetopt_strdup("") ;\
  args_info->slope_arg = gengetopt_strdup("both") ;\
  args_info->tmax_arg = 60 ;\
  args_info->dmax_arg = 0 ;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "conf",	1, NULL, 'c' },
        { "name",	1, NULL, 'n' },
        { "value",	1, NULL, 'v' },
        { "type",	1, NULL, 't' },
        { "units",	1, NULL, 'u' },
        { "slope",	1, NULL, 's' },
        { "tmax",	1, NULL, 'x' },
        { "dmax",	1, NULL, 'd' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVc:n:v:t:u:s:x:d:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'c':	/* The configuration file to use for finding send channels.  */
          if (args_info->conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->conf_given = 1;
          if (args_info->conf_arg)
            free (args_info->conf_arg); /* free default string */
          args_info->conf_arg = gengetopt_strdup (optarg);
          break;

        case 'n':	/* Name of the metric.  */
          if (args_info->name_given)
            {
              fprintf (stderr, "%s: `--name' (`-n') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->name_given = 1;
          args_info->name_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Value of the metric.  */
          if (args_info->value_given)
            {
              fprintf (stderr, "%s: `--value' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->value_given = 1;
          args_info->value_arg = gengetopt_strdup (optarg);
          break;

        case 't':	/* Either string|int8|uint8|int16|uint16|int32|uint32|float|double.  */
          if (args_info->type_given)
            {
              fprintf (stderr, "%s: `--type' (`-t') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->type_given = 1;
          args_info->type_arg = gengetopt_strdup (optarg);
          break;

        case 'u':	/* Unit of measure for the value e.g. Kilobytes, Celcius.  */
          if (args_info->units_given)
            {
              fprintf (stderr, "%s: `--units' (`-u') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->units_given = 1;
          if (args_info->units_arg)
            free (args_info->units_arg); /* free default string */
          args_info->units_arg = gengetopt_strdup (optarg);
          break;

        case 's':	/* Either zero|positive|negative|both.  */
          if (args_info->slope_given)
            {
              fprintf (stderr, "%s: `--slope' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->slope_given = 1;
          if (args_info->slope_arg)
            free (args_info->slope_arg); /* free default string */
          args_info->slope_arg = gengetopt_strdup (optarg);
          break;

        case 'x':	/* The maximum time in seconds between gmetric calls.  */
          if (args_info->tmax_given)
            {
              fprintf (stderr, "%s: `--tmax' (`-x') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->tmax_given = 1;
          args_info->tmax_arg = strtol (optarg,&stop_char,0);
          break;

        case 'd':	/* The lifetime in seconds of this metric.  */
          if (args_info->dmax_given)
            {
              fprintf (stderr, "%s: `--dmax' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->dmax_given = 1;
          args_info->dmax_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if (! args_info->name_given)
    {
      fprintf (stderr, "%s: '--name' ('-n') option required\n", CMDLINE_PARSER_PACKAGE);
      missing_required_options = 1;
    }
  if (! args_info->value_given)
    {
      fprintf (stderr, "%s: '--value' ('-v') option required\n", CMDLINE_PARSER_PACKAGE);
      missing_required_options = 1;
    }
  if (! args_info->type_given)
    {
      fprintf (stderr, "%s: '--type' ('-t') option required\n", CMDLINE_PARSER_PACKAGE);
      missing_required_options = 1;
    }
  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
