/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.swing.table.AbstractTableModel;

public class RowSetAdapter
extends AbstractTableModel {
    private RowSet rowset;
    private ResultSetMetaData metaData;

    private RowSetAdapter(RowSet rowset) throws SQLException {
        if (rowset == null) {
            throw new NullPointerException("rowset cannot be null");
        }
        this.rowset = rowset;
        this.metaData = rowset.getMetaData();
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> klass = null;
        try {
            klass = Class.forName(this.metaData.getColumnClassName(this.translateAdapterColumn(columnIndex)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return klass;
    }

    public int getRowCount() {
        return 0;
    }

    public int getColumnCount() {
        int columnCount = 0;
        try {
            columnCount = this.metaData.getColumnCount();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        try {
            RowSet rowSet = this.rowset;
            synchronized (rowSet) {
                this.rowset.absolute(this.translateAdapterRow(rowIndex));
                value = this.rowset.getObject(this.translateAdapterColumn(columnIndex));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editable = false;
        try {
            editable = this.metaData.isWritable(this.translateAdapterColumn(columnIndex));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return editable;
    }

    protected int translateAdapterColumn(int columnIndex) {
        return columnIndex + 1;
    }

    protected int translateDataColumn(int dataColumnIndex) {
        return dataColumnIndex - 1;
    }

    protected int translateAdapterRow(int rowIndex) {
        return rowIndex + 1;
    }

    protected int translateDataRow(int dataRowIndex) {
        return dataRowIndex - 1;
    }
}

