/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.form;

import java.awt.event.ActionEvent;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.swing.UIAction;
import org.jdesktop.swing.binding.BindException;
import org.jdesktop.swing.binding.Binding;
import org.jdesktop.swing.data.DataModel;
import org.jdesktop.swing.data.JavaBeanDataModel;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.TabularDataModel;
import org.jdesktop.swing.data.TabularDataModelAdapter;
import org.jdesktop.swing.data.Validator;
import org.jdesktop.swing.form.FormFactory;

public class JForm
extends JPanel {
    private FormFactory formFactory;
    private ArrayList bindings;
    private DataModel model;
    private boolean autoLayout = true;
    private HashMap models;

    public JForm() {
        this.initActions();
    }

    public JForm(DataModel model) throws BindException {
        this.initActions();
        this.bind(model);
        this.pull();
    }

    protected void initActions() {
        ActionMap map = this.getActionMap();
        map.put("submit", new Actions("submit"));
        map.put("reset", new Actions("reset"));
    }

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    public boolean getAutoLayout() {
        return this.autoLayout;
    }

    public void setFormFactory(FormFactory factory) {
        this.formFactory = factory;
    }

    public FormFactory getFormFactory() {
        if (this.formFactory == null) {
            return FormFactory.getDefaultFormFactory();
        }
        return this.formFactory;
    }

    public Binding[] bind(TabularDataModel tabularData) throws BindException {
        return this.bind(this.getDataModelWrapper(tabularData));
    }

    public Binding bind(TabularDataModel tabularData, String columnName) throws BindException {
        return this.bind(this.getDataModelWrapper(tabularData), columnName);
    }

    public Binding[] bind(Object bean) throws BindException {
        return this.bind(this.getDataModelWrapper(bean));
    }

    public Binding bind(Object bean, String propertyName) throws BindException {
        return this.bind(this.getDataModelWrapper(bean), propertyName);
    }

    public Binding[] bind(DataModel model) throws BindException {
        String[] fieldNames = model.getFieldNames();
        Binding[] bindings = new Binding[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            bindings[i] = this.bind(model, fieldNames[i]);
            ++i;
        }
        return bindings;
    }

    public Binding bind(DataModel model, String fieldName) throws BindException {
        JComponent component = this.getFormFactory().createComponent(model.getMetaData(fieldName));
        if (component instanceof JForm) {
            DataModel nestedModel = (DataModel)model.getValue(fieldName);
            if (nestedModel != null) {
                JForm nestedForm = (JForm)component;
                nestedForm.bind(nestedModel);
                return this.bind(model, fieldName, nestedForm);
            }
            throw new BindException((Object)model, fieldName);
        }
        return this.bind(model, fieldName, component);
    }

    public Binding bind(DataModel model, String fieldName, JComponent component) throws BindException {
        Binding binding = this.getFormFactory().createBinding(model, fieldName, component);
        if (binding != null) {
            return this.bind(binding, component);
        }
        throw new BindException("could not create binding for component " + component.getClass().getName());
    }

    public Binding bind(Binding binding, JComponent component) throws BindException {
        this.addBinding(binding);
        if (this.autoLayout) {
            DataModel model = binding.getDataModel();
            MetaData metaData = model.getMetaData(binding.getFieldName());
            this.getFormFactory().addComponent(this, component, metaData);
        }
        return binding;
    }

    protected void addBinding(Binding binding) {
        if (this.bindings == null) {
            this.bindings = new ArrayList();
        }
        this.bindings.add(binding);
    }

    public void unbind(Binding binding) {
        if (this.bindings != null) {
            this.bindings.remove(binding);
        }
    }

    public Binding[] getBindings() {
        if (this.bindings != null) {
            return this.bindings.toArray(new Binding[0]);
        }
        return new Binding[0];
    }

    public boolean pull() {
        boolean result = true;
        Binding[] bindings = this.getBindings();
        int i = 0;
        while (i < bindings.length) {
            if (!bindings[i].pull()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public boolean isFormValid() {
        boolean result = true;
        Binding[] bindings = this.getBindings();
        ArrayList<DataModel> models = new ArrayList<DataModel>();
        int i = 0;
        while (i < bindings.length) {
            DataModel bindingModel = bindings[i].getDataModel();
            if (!models.contains(bindingModel)) {
                models.add(bindingModel);
            }
            if (!bindings[i].isValid()) {
                result = false;
            }
            ++i;
        }
        if (result) {
            i = 0;
            while (i < models.size()) {
                DataModel model = (DataModel)models.get(i);
                Validator[] validators = model.getValidators();
                int j = 0;
                while (j < validators.length) {
                    String[] error = new String[1];
                    if (!validators[j].validate(model, this.getLocale(), error)) {
                        result = false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean isModified() {
        boolean result = false;
        Binding[] bindings = this.getBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].isModified()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void doSubmit() {
        if (this.push()) {
            this.executeSubmit();
        } else {
            JOptionPane.showMessageDialog(this, "Form contains invalid values.\nPlease correct values before submitting.", "Form Submission Error", 0);
        }
    }

    public void doReset() {
        this.pull();
    }

    public boolean push() {
        if (!this.isFormValid()) {
            return false;
        }
        boolean result = true;
        Binding[] bindings = this.getBindings();
        int i = 0;
        while (i < bindings.length) {
            if (!bindings[i].push()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    protected void executeSubmit() {
        JOptionPane.showMessageDialog(this, "Form submitted.\nThanks", "Form Submission", -1);
    }

    private DataModel getDataModelWrapper(Object model) throws BindException {
        DataModel wrapper;
        if (this.models == null) {
            this.models = new HashMap();
        }
        if ((wrapper = (DataModel)this.models.get(model)) == null) {
            if (model instanceof TabularDataModel) {
                wrapper = new TabularDataModelAdapter((TabularDataModel)model);
            } else {
                try {
                    wrapper = new JavaBeanDataModel(model.getClass(), model);
                }
                catch (IntrospectionException e) {
                    throw new BindException(model, (Throwable)e);
                }
            }
            this.models.put(model, wrapper);
        }
        return wrapper;
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("submit".equals(this.getName())) {
                JForm.this.doSubmit();
            } else if ("reset".equals(this.getName())) {
                JForm.this.doReset();
            }
        }
    }
}

