/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swing.data.Link;

public class TableCellRenderers {
    private static HashMap typeMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz, "org.jdesktop.swing.table.TableCellRenderers$NumberRenderer");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz2, "org.jdesktop.swing.table.TableCellRenderers$DoubleRenderer");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz3, "org.jdesktop.swing.table.TableCellRenderers$DoubleRenderer");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz4, "org.jdesktop.swing.table.TableCellRenderers$DateRenderer");
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("javax.swing.Icon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz5, "org.jdesktop.swing.table.TableCellRenderers$IconRenderer");
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz6, "org.jdesktop.swing.table.TableCellRenderers$BooleanRenderer");
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.jdesktop.swing.data.Link");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap.put(clazz7, "org.jdesktop.swing.table.TableCellRenderers$LinkRenderer");
    }

    private static String getRendererClassName(Class columnClass) {
        String rendererClassName = (String)typeMap.get(columnClass);
        return rendererClassName != null ? rendererClassName : "javax.swing.table.DefaultTableCellRenderer";
    }

    public static void setDefaultRenderer(Class columnClass, String rendererClassName) {
        typeMap.put(columnClass, rendererClassName);
    }

    public static TableCellRenderer getNewDefaultRenderer(Class columnClass) {
        TableCellRenderer renderer = null;
        String rendererClassName = TableCellRenderers.getRendererClassName(columnClass);
        try {
            Class<?> rendererClass = Class.forName(rendererClassName);
            renderer = (TableCellRenderer)rendererClass.newInstance();
        }
        catch (Exception e) {
            renderer = new DefaultTableCellRenderer();
        }
        return renderer;
    }

    TableCellRenderers() {
    }

    static Rectangle getTextBounds(Graphics g, JLabel label) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r2d = fm.getStringBounds(label.getText(), g);
        Rectangle rect = r2d.getBounds();
        int xOffset = 0;
        switch (label.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                xOffset = label.getBounds().width - rect.width;
                break;
            }
            case 0: {
                xOffset = (label.getBounds().width - rect.width) / 2;
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        int yOffset = 0;
        switch (label.getVerticalAlignment()) {
            case 1: {
                yOffset = 0;
                break;
            }
            case 0: {
                yOffset = (label.getBounds().height - rect.height) / 2;
                break;
            }
            case 3: {
                yOffset = label.getBounds().height - rect.height;
            }
        }
        return new Rectangle(xOffset, yOffset, rect.width, rect.height);
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            System.out.println(value.toString());
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public static class LinkRenderer
    extends DefaultTableCellRenderer {
        private static Color colorLive = new Color(0, 0, 238);
        private static Color colorVisited = new Color(82, 24, 139);

        public void setValue(Object value) {
            if (value != null && value instanceof Link) {
                Link link = (Link)value;
                this.setText(link.getText());
                this.setToolTipText(link.getURL().toString());
                if (link.getVisited()) {
                    this.setForeground(colorVisited);
                } else {
                    this.setForeground(colorLive);
                }
            } else {
                super.setValue(value != null ? value.toString() : "");
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.getText().equals("")) {
                Rectangle rect = TableCellRenderers.getTextBounds(g, this);
                FontMetrics fm = g.getFontMetrics();
                int descent = fm.getDescent();
                g.drawLine(rect.x, rect.y + rect.height - descent + 1, rect.x + rect.width, rect.y + rect.height - descent + 1);
            }
        }
    }
}

