/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpp;

import com.tapsterrock.mpp.MPPComponent;
import com.tapsterrock.mpp.MPPUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

final class VarMeta
extends MPPComponent {
    private int m_unknown1;
    private int m_itemCount;
    private int m_unknown2;
    private int m_unknown3;
    private int m_dataSize;
    private int[] m_offsets;
    private TreeMap m_table = new TreeMap();
    private static final int MAGIC = -86004294;

    VarMeta(InputStream is) throws IOException {
        if (this.readInt(is) != -86004294) {
            throw new IOException("Bad magic number");
        }
        this.m_unknown1 = this.readInt(is);
        this.m_itemCount = this.readInt(is);
        this.m_unknown2 = this.readInt(is);
        this.m_unknown3 = this.readInt(is);
        this.m_dataSize = this.readInt(is);
        this.m_offsets = new int[this.m_itemCount];
        byte[] uniqueIDArray = new byte[4];
        for (int loop = 0; loop < this.m_itemCount; ++loop) {
            is.read(uniqueIDArray, 0, 3);
            Integer uniqueID = new Integer(MPPUtility.getInt(uniqueIDArray));
            Integer type = new Integer(this.readByte(is));
            Integer offset = new Integer(this.readInt(is));
            TreeMap<Integer, Integer> map = (TreeMap<Integer, Integer>)this.m_table.get(uniqueID);
            if (map == null) {
                map = new TreeMap<Integer, Integer>();
                this.m_table.put(uniqueID, map);
            }
            map.put(type, offset);
            this.m_offsets[loop] = offset;
        }
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public int getDataSize() {
        return this.m_dataSize;
    }

    public Integer[] getUniqueIdentifierArray() {
        Integer[] result = new Integer[this.m_table.size()];
        Iterator iter = this.m_table.keySet().iterator();
        int index = 0;
        while (iter.hasNext()) {
            result[index] = (Integer)iter.next();
            ++index;
        }
        return result;
    }

    public Set getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    public Integer getOffset(Integer id, Integer type) {
        Integer result = null;
        TreeMap map = (TreeMap)this.m_table.get(id);
        if (map != null) {
            result = (Integer)map.get(type);
        }
        return result;
    }

    public int getOffset(int index) {
        return this.m_offsets[index];
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: VarMeta");
        pw.println("   Item count: " + this.m_itemCount);
        pw.println("   Data size: " + this.m_dataSize);
        Iterator tableIter = this.m_table.keySet().iterator();
        while (tableIter.hasNext()) {
            Integer uniqueID = (Integer)tableIter.next();
            pw.println("   Entries for Unique ID: " + uniqueID);
            TreeMap map = (TreeMap)this.m_table.get(uniqueID);
            Iterator mapIter = map.keySet().iterator();
            while (mapIter.hasNext()) {
                Integer type = (Integer)mapIter.next();
                Integer offset = (Integer)map.get(type);
                pw.println("      Type=" + type + " Offset=" + offset);
            }
        }
        pw.println("END: VarMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

