/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Record;
import java.util.HashMap;
import java.util.Locale;

final class ResourceModel
extends MPXRecord {
    private boolean m_written;
    private boolean[] m_flags = new boolean[52];
    private int[] m_fields = new int[53];
    private int m_count;
    private String[] m_resourceNames;
    private HashMap m_resourceNumbers = new HashMap();
    static final int RECORD_NUMBER_TEXT = 40;
    static final int RECORD_NUMBER_NUMERIC = 41;

    ResourceModel(MPXFile file) {
        super(file, 0);
        this.setLocale(file.getLocale());
    }

    void setLocale(Locale locale) {
        this.m_resourceNames = LocaleData.getStringArray(locale, "RESOURCE_NAMES");
        this.m_resourceNumbers.clear();
        for (int loop = 0; loop < this.m_resourceNames.length; ++loop) {
            String name = this.m_resourceNames[loop];
            if (name == null) continue;
            this.m_resourceNumbers.put(name, new Integer(loop));
        }
    }

    public void update(Record record, boolean isText) throws MPXException {
        int length = record.getLength();
        for (int i = 0; i < length; ++i) {
            if (isText) {
                this.add(this.getResourceCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    public String toString() {
        char delimiter = this.getParentFile().getDelimiter();
        StringBuffer textual = new StringBuffer();
        StringBuffer numeric = new StringBuffer();
        textual.append(40);
        numeric.append(41);
        for (int loop = 0; loop < this.m_count; ++loop) {
            int number = this.m_fields[loop];
            textual.append(delimiter);
            numeric.append(delimiter);
            textual.append(this.getResourceField(number));
            numeric.append(number);
        }
        textual.append("\r\n");
        numeric.append("\r\n");
        textual.append(numeric.toString());
        return textual.toString();
    }

    public boolean getWritten() {
        return this.m_written;
    }

    public void setWritten(boolean written) {
        this.m_written = written;
    }

    public void add(int field) {
        if (field < this.m_flags.length && !this.m_flags[field]) {
            this.m_flags[field] = true;
            this.m_fields[this.m_count] = field;
            ++this.m_count;
        }
    }

    private String getResourceField(int key) {
        String result = null;
        if (key > 0 && key < this.m_resourceNames.length) {
            result = this.m_resourceNames[key];
        }
        return result;
    }

    private int getResourceCode(String field) throws MPXException {
        Integer result = (Integer)this.m_resourceNumbers.get(field);
        if (result == null) {
            throw new MPXException("Invalid resource field name " + field);
        }
        return result;
    }
}

